package jlama;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import java.util.List;

public class KeywordNode extends DefaultMutableTreeNode {
    private List<Article> articles = new ArrayList<>();

    public KeywordNode(Keyword keyword) {
        super(keyword);
    }

    public Keyword getKeyword() {
        return (Keyword)getUserObject();
    }

    public List<Article> getArticles() {
        return articles;
    }

    public void addArticle(Article article) {
        articles.add(article);
    }

    public void merge(KeywordNode keywordNode) {
        articles.addAll(keywordNode.getArticles());
    }
}
