/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.telemetry;

/**
 * Telemetry unit used in the {@link TelemetryFormat} annotation.
 */
public enum TelemetryUnit {
    /**
     * The telemetry value is a unitless number.
     */
    PLAIN,
    /**
     * The telemetry value has the unit "per second".
     */
    PER_SECOND,
    /**
     * The telemetry value has the unit "percent".
     */
    PERCENT,
    /**
     * The telemetry value has the unit "milliseconds". Conversion into higher unit prefixes such as seconds
     * is done automatically as required.
     */
    MILLISECONDS,
    /**
     * The telemetry value has the unit "microseconds". Conversion into higher unit prefixes such as seconds
     * is done automatically as required.
     */
    MICROSECONDS,
    /**
     * The telemetry value has the unit "bytes". Conversion into higher unit prefixes such as kB, MB or GB
     * is done automatically as required.
     * <p>
     * In JProfiler, probe telemetry data is stored in 32-bit ints. If you expect higher values than 2^31 bytes, you can
     * for example return kB instead and set {@link TelemetryFormat#scale()} to {@code -3}.
     * </p>
     */
    BYTES
}
