/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.embedded.telemetry;

/**
 * Display options for a {@link Telemetry} annotation.
 * This annotation is used by the {@link Telemetry#format()} parameter.
 */
public @interface TelemetryFormat {
    /**
     * The unit of the recorded values. By default, telemetries are unitless.
     */
    TelemetryUnit value() default TelemetryUnit.PLAIN;

    /**
     * A scaling factor for the telemetry. In the UI recorded values will be multiplied with {@code 10^-scale}.
     * <p>
     * In JProfiler, probe telemetry data is stored in 32-bit ints. So this is especially useful for telemetries that
     * will show higher values than 2^31. For example, if you use the
     * {@link TelemetryUnit#BYTES} you can return kB instead and set the scale to {@code -3}.
     * </p>
     * <p>
     * This is also useful to show fractional values. For example, if you want to show a percentage with two decimal digits,
     * the returned value should be the percentage times 100 and the scale parameter should be set to {@code 2}.
     * </p>
     */
    int scale() default 0;

    /**
     * Determines whether multiple lines in a telemetry should be stacked into an area graph.
     * By default, multiple telemetry lines are not stacked. An example of a stacked graph is the "Heap usage" telemetry.
     */
    boolean stacked() default false;
}
