/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
/**
 * <p>
 * Contains the classes for creating an embedded probe.
 * </p>
 * <b>Purpose of embedded probes</b>
 * <p>
 * Please read the "Probe concepts" chapter in the documentation (directory {@code $JPROFILER_HOME/doc}) for
 * an overview on the different types of custom probes in JProfiler and the "Embedded probes" chapter
 * for an extended discussion of embedded probes.
 * </p>
 * <p>
 * Embedded probes allow you to add functionality similar to the built-in probes in JProfiler. In contrast to
 * the "injected" probe API, the "embedded" probe API is called directly from the monitored software. If you want to
 * monitor software components whose source code is not under your control, use the injected probe API instead.
 * </p>
 * <b>Getting started</b>
 * <p>There are two types of embedded probes, split probes and payloads probes.
 * Please see {@link com.jprofiler.api.probe.embedded.Split} and {@link com.jprofiler.api.probe.embedded.Payload}
 * for further information.</p>
 * <p>
 * To get started with writing embedded probes, have a look at the {@code $JPROFILER_HOME/api/samples/simple-embedded-probe}
 * example project. Open the gradle build file {@code build.gradle} in an editor for instructions on how to run it.
 * </p>
 * <b>JAR file and dependency</b>
 * <p>
 * All classes in this package are contained in {@code $JPROFILER_HOME/api/jprofiler-probe-embedded.jar}.
 * The embedded probe API is also available as a dependency. In the snippets below, "VERSION"
 * should be replaced with the corresponding JProfiler version.
 * </p>
 * <b>Maven</b>
 * <pre>{@code
 * <dependency>
 *   <groupId>com.jprofiler</groupId>
 *   <artifactId>jprofiler-probe-embedded</artifactId>
 *   <version>VERSION</version>
 * </dependency>
 * }</pre>
 * <b>Gradle</b>
 * <pre>{@code
 * dependencies {
 *   classpath group: 'com.jprofiler', name: 'jprofiler-probe-embedded', version: 'VERSION'
 * }
 * }</pre>
 * <b>License</b>
 * <p>
 * Classes in this package and its sub-packages are licensed under the Apache License, version 2.0.
 * </p>
 */
package com.jprofiler.api.probe.embedded;
