/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.DetailPane;
import org.gjt.jclasslib.structures.Structure;
import org.gjt.jclasslib.util.TitledSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001'B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H$J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H$J\b\u0010\u0014\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005J3\u0010\u001b\u001a\u001c\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00050\u001c2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005H\u0082\u0010J\u001e\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u00052\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020 H\u0002J$\u0010%\u001a\u00020\u00122\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0004RB\u0010\n\u001a6\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u000bj\u001a\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lorg/gjt/jclasslib/browser/detail/MultiDetailPane;", "T", "Lorg/gjt/jclasslib/structures/Structure;", "Lorg/gjt/jclasslib/browser/DetailPane;", "elementClass", "Ljava/lang/Class;", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Ljava/lang/Class;Lorg/gjt/jclasslib/browser/BrowserServices;)V", "elementClassToDetailPane", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "currentDetailPane", "specificInfoPane", "Ljavax/swing/JPanel;", "genericInfoPane", "addCards", "", "createGenericInfoPane", "setupComponent", "show", "treePath", "Ljavax/swing/tree/TreePath;", "showEmptyCard", "getDetailPane", "elementValueClass", "getDetailPaneWithClass", "Lkotlin/Pair;", "castToElementClass", "c", "clipboardText", "", "getClipboardText", "()Ljava/lang/String;", "showCard", "cardName", "addCard", "detailPane", "Companion", "browser"})
public abstract class MultiDetailPane<T extends Structure>
extends DetailPane<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Class<? extends T>, DetailPane<?>> elementClassToDetailPane;
    @Nullable
    private DetailPane<?> currentDetailPane;
    @NotNull
    private final JPanel specificInfoPane;
    @NotNull
    private final DetailPane<?> genericInfoPane;
    @NotNull
    private static final String NAME_UNKNOWN = "Unknown";

    /*
     * WARNING - void declaration
     */
    public MultiDetailPane(@NotNull Class<T> elementClass, @NotNull BrowserServices services) {
        void $this$specificInfoPane_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        super(elementClass, services);
        this.elementClassToDetailPane = new HashMap();
        JPanel jPanel2 = jPanel = new JPanel();
        MultiDetailPane multiDetailPane = this;
        boolean bl = false;
        $this$specificInfoPane_u24lambda_u240.setLayout(new CardLayout());
        $this$specificInfoPane_u24lambda_u240.add((Component)new JPanel(), NAME_UNKNOWN);
        multiDetailPane.specificInfoPane = jPanel;
        this.genericInfoPane = this.createGenericInfoPane();
    }

    protected abstract void addCards();

    @NotNull
    protected abstract DetailPane<?> createGenericInfoPane();

    @Override
    protected void setupComponent() {
        this.addCards();
        this.setLayout((LayoutManager)new MigLayout("wrap", "[grow]", "[][shrinkprio 50]para[][grow]"));
        this.add((Component)new TitledSeparator(BrowserBundle.INSTANCE.getString("detail.generic.info.title", new Object[0])), "growx");
        this.add((Component)this.genericInfoPane.getDisplayComponent(), "growx");
        this.add((Component)new TitledSeparator(BrowserBundle.INSTANCE.getString("detail.specific.info.title", new Object[0])), "growx");
        this.add((Component)this.specificInfoPane, "grow");
    }

    @Override
    public void show(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        Structure element = (Structure)this.getElementOrNull(treePath);
        if (element == null) {
            this.showEmptyCard();
        } else {
            Pair<DetailPane<?>, Class<?>> pair = this.getDetailPaneWithClass(element.getClass());
            DetailPane detailPane = (DetailPane)pair.component1();
            Class detailClass = (Class)pair.component2();
            if (detailPane != null) {
                this.currentDetailPane = detailPane;
                String string = detailClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.showCard(string);
                detailPane.show(treePath);
            } else {
                this.showEmptyCard();
            }
        }
        this.genericInfoPane.show(treePath);
    }

    private final void showEmptyCard() {
        this.showCard(NAME_UNKNOWN);
        this.currentDetailPane = null;
    }

    @Nullable
    public final DetailPane<?> getDetailPane(@NotNull Class<? extends T> elementValueClass) {
        Intrinsics.checkNotNullParameter(elementValueClass, (String)"elementValueClass");
        return (DetailPane)this.getDetailPaneWithClass(elementValueClass).getFirst();
    }

    private final Pair<DetailPane<?>, Class<? extends T>> getDetailPaneWithClass(Class<? extends T> elementValueClass) {
        Pair pair;
        MultiDetailPane multiDetailPane = this;
        while (true) {
            DetailPane<?> detailPane;
            if ((detailPane = multiDetailPane.elementClassToDetailPane.get(elementValueClass)) != null) {
                pair = TuplesKt.to(detailPane, elementValueClass);
                break;
            }
            Class<? extends T> clazz = elementValueClass.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            Class<T> superclass = multiDetailPane.castToElementClass(clazz);
            if (superclass == null) {
                pair = TuplesKt.to(null, elementValueClass);
                break;
            }
            MultiDetailPane multiDetailPane2 = multiDetailPane;
            Class<T> clazz2 = superclass;
            multiDetailPane = multiDetailPane2;
            elementValueClass = clazz2;
        }
        return pair;
    }

    private final Class<? extends T> castToElementClass(Class<?> c) {
        Class<?> clazz;
        if (this.getElementClass().isAssignableFrom(c)) {
            Intrinsics.checkNotNull(c, (String)"null cannot be cast to non-null type java.lang.Class<out T of org.gjt.jclasslib.browser.detail.MultiDetailPane>");
            clazz = c;
        } else {
            clazz = null;
        }
        return clazz;
    }

    @Override
    @Nullable
    public String getClipboardText() {
        DetailPane<?> detailPane = this.currentDetailPane;
        return detailPane != null ? detailPane.getClipboardText() : null;
    }

    private final void showCard(String cardName) {
        LayoutManager layoutManager = this.specificInfoPane.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        ((CardLayout)layoutManager).show(this.specificInfoPane, cardName);
    }

    protected final void addCard(@NotNull Class<? extends T> elementValueClass, @NotNull DetailPane<?> detailPane) {
        Intrinsics.checkNotNullParameter(elementValueClass, (String)"elementValueClass");
        Intrinsics.checkNotNullParameter(detailPane, (String)"detailPane");
        this.specificInfoPane.add((Component)detailPane.getDisplayComponent(), elementValueClass.getName());
        ((Map)this.elementClassToDetailPane).put(elementValueClass, detailPane);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gjt/jclasslib/browser/detail/MultiDetailPane$Companion;", "", "<init>", "()V", "NAME_UNKNOWN", "", "browser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

