/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.dom.build.BuilderKt;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathFileEntry;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0016R\u001b\u0010\u0006\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/gjt/jclasslib/browser/config/classpath/ClasspathArchiveEntry;", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathFileEntry;", "fileName", "", "<init>", "(Ljava/lang/String;)V", "moduleName", "getModuleName", "()Ljava/lang/String;", "moduleName$delegate", "Lkotlin/Lazy;", "saveWorkspace", "", "element", "Lorg/w3c/dom/Element;", "findClass", "Lorg/gjt/jclasslib/browser/config/classpath/FindResult;", "className", "modulePathSelection", "", "mergeClassesIntoTree", "classPathModel", "Ljavax/swing/tree/DefaultTreeModel;", "modulePathModel", "reset", "Companion", "browser"})
@SourceDebugExtension(value={"SMAP\nClasspathArchiveEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathArchiveEntry.kt\norg/gjt/jclasslib/browser/config/classpath/ClasspathArchiveEntry\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,70:1\n32#2,2:71\n*S KotlinDebug\n*F\n+ 1 ClasspathArchiveEntry.kt\norg/gjt/jclasslib/browser/config/classpath/ClasspathArchiveEntry\n*L\n53#1:71,2\n*E\n"})
public final class ClasspathArchiveEntry
extends ClasspathFileEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy moduleName$delegate;
    @NotNull
    public static final String NODE_NAME = "archive";
    @NotNull
    private static final String ATTRIBUTE_PATH = "path";

    public ClasspathArchiveEntry(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(fileName);
        this.moduleName$delegate = LazyKt.lazy(() -> ClasspathArchiveEntry.moduleName_delegate$lambda$0(this));
    }

    private final String getModuleName() {
        Lazy lazy = this.moduleName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public void saveWorkspace(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BuilderKt.addElement$default((Element)element, (String)NODE_NAME, null, arg_0 -> ClasspathArchiveEntry.saveWorkspace$lambda$0(this, arg_0), (int)2, null);
    }

    @Override
    @Nullable
    public FindResult findClass(@NotNull String className, boolean modulePathSelection) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (!modulePathSelection || Intrinsics.areEqual((Object)ClasspathEntry.Companion.getModuleName(className), (Object)this.getModuleName())) {
            String fileName = StringsKt.replace$default((String)ClasspathEntry.Companion.getClassPathClassName(className, modulePathSelection), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
            try {
                JarFile jarFile = new JarFile(this.getFile());
                JarEntry entry = jarFile.getJarEntry(fileName);
                if (entry != null) {
                    return new FindResult(this.getFile().getPath() + "!" + fileName, this.getModuleName());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeClassesIntoTree(@NotNull DefaultTreeModel classPathModel, @NotNull DefaultTreeModel modulePathModel, boolean reset) {
        Intrinsics.checkNotNullParameter((Object)classPathModel, (String)"classPathModel");
        Intrinsics.checkNotNullParameter((Object)modulePathModel, (String)"modulePathModel");
        try {
            Closeable closeable = new JarFile(this.getFile());
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl = false;
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Iterator $this$forEach$iv = CollectionsKt.iterator(enumeration);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    JarEntry it = (JarEntry)element$iv;
                    boolean bl2 = false;
                    if (it.isDirectory()) continue;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (!StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) continue;
                    String string3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    this.addEntry(string3, this.getModuleName(), classPathModel, modulePathModel, reset);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String moduleName_delegate$lambda$0(ClasspathArchiveEntry this$0) {
        String string;
        Closeable closeable = new JarFile(this$0.getFile());
        Throwable throwable = null;
        try {
            String string2;
            JarFile jarFile = (JarFile)closeable;
            boolean bl = false;
            JarEntry moduleInfoEntry = jarFile.getJarEntry("module-info.class");
            if (moduleInfoEntry != null) {
                InputStream inputStream = jarFile.getInputStream(moduleInfoEntry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                string2 = this$0.getModuleName(inputStream);
            } else {
                string2 = null;
            }
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string4 = string;
        if (string == null) {
            string4 = "<unnamed module>";
        }
        return string4;
    }

    private static final Unit saveWorkspace$lambda$0(ClasspathArchiveEntry this$0, Element $this$addElement) {
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
        $this$addElement.setAttribute(ATTRIBUTE_PATH, this$0.getFile().getPath());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gjt/jclasslib/browser/config/classpath/ClasspathArchiveEntry$Companion;", "", "<init>", "()V", "NODE_NAME", "", "ATTRIBUTE_PATH", "create", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathArchiveEntry;", "element", "Lorg/w3c/dom/Element;", "browser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClasspathArchiveEntry create(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getAttribute(ClasspathArchiveEntry.ATTRIBUTE_PATH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            return new ClasspathArchiveEntry(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

