/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.util.HtmlDisplayTextArea;
import org.gjt.jclasslib.util.MultiLineLabel;
import org.gjt.jclasslib.util.UiDefaultsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 6*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u00016B\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u000fH$J\u0014\u0010\u001f\u001a\u00020\u000f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010!\u001a\u00020\"H\u0004J\b\u0010#\u001a\u00020$H\u0004J\u0013\u0010%\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010&J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010*\u001a\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020,J \u0010*\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020)H\u0014J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u000203H\u0004J\u0006\u00104\u001a\u00020\u000fJ\b\u00105\u001a\u00020\u000fH\u0014R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001a\u00a8\u00067"}, d2={"Lorg/gjt/jclasslib/browser/DetailPane;", "T", "", "Ljavax/swing/JPanel;", "elementClass", "Ljava/lang/Class;", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Ljava/lang/Class;Lorg/gjt/jclasslib/browser/BrowserServices;)V", "getElementClass", "()Ljava/lang/Class;", "getServices", "()Lorg/gjt/jclasslib/browser/BrowserServices;", "show", "", "treePath", "Ljavax/swing/tree/TreePath;", "setupComponent", "clipboardText", "", "getClipboardText", "()Ljava/lang/String;", "displayComponent", "Ljavax/swing/JComponent;", "getDisplayComponent", "()Ljavax/swing/JComponent;", "displayComponent$delegate", "Lkotlin/Lazy;", "wrapper", "getWrapper", "setName", "name", "highlightTextArea", "Lorg/gjt/jclasslib/util/HtmlDisplayTextArea;", "multiLineLabel", "Lorg/gjt/jclasslib/util/MultiLineLabel;", "getElement", "(Ljavax/swing/tree/TreePath;)Ljava/lang/Object;", "getElementOrNull", "treeNode", "Lorg/gjt/jclasslib/browser/BrowserTreeNode;", "updateFilter", "expand", "", "tree", "Ljavax/swing/JTree;", "isChildShown", "node", "getConstantPoolEntryName", "constantPoolIndex", "", "modified", "refresh", "Companion", "browser"})
public abstract class DetailPane<T>
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? extends T> elementClass;
    @NotNull
    private final BrowserServices services;
    @NotNull
    private final Lazy displayComponent$delegate;
    @NotNull
    public static final String CPINFO_LINK_TEXT = "cp_info #";

    public DetailPane(@NotNull Class<? extends T> elementClass, @NotNull BrowserServices services) {
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        this.elementClass = elementClass;
        this.services = services;
        this.displayComponent$delegate = LazyKt.lazy(() -> DetailPane.displayComponent_delegate$lambda$0(this));
    }

    @NotNull
    protected final Class<? extends T> getElementClass() {
        return this.elementClass;
    }

    @NotNull
    public final BrowserServices getServices() {
        return this.services;
    }

    public abstract void show(@NotNull TreePath var1);

    protected abstract void setupComponent();

    @Nullable
    public String getClipboardText() {
        return null;
    }

    @NotNull
    public final JComponent getDisplayComponent() {
        Lazy lazy = this.displayComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    protected JComponent getWrapper() {
        return this;
    }

    @Override
    public void setName(@Nls @Nullable String name) {
        super.setName(name);
    }

    @NotNull
    protected final HtmlDisplayTextArea highlightTextArea() {
        HtmlDisplayTextArea htmlDisplayTextArea;
        HtmlDisplayTextArea $this$highlightTextArea_u24lambda_u240 = htmlDisplayTextArea = new HtmlDisplayTextArea(null, 1, null);
        boolean bl = false;
        $this$highlightTextArea_u24lambda_u240.setForeground(UiDefaultsKt.getValueColor());
        return htmlDisplayTextArea;
    }

    @NotNull
    protected final MultiLineLabel multiLineLabel() {
        MultiLineLabel multiLineLabel;
        MultiLineLabel $this$multiLineLabel_u24lambda_u240 = multiLineLabel = new MultiLineLabel();
        boolean bl = false;
        $this$multiLineLabel_u24lambda_u240.setForeground(UiDefaultsKt.getValueColor());
        return multiLineLabel;
    }

    @NotNull
    public final T getElement(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        T t = this.getElementOrNull(treePath);
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Nullable
    public final T getElementOrNull(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        return this.elementClass.cast(this.treeNode(treePath).getElement());
    }

    @NotNull
    public final BrowserTreeNode treeNode(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        Object object = treePath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        return (BrowserTreeNode)object;
    }

    public final void updateFilter(boolean expand) {
        BrowserTreeNode treeNode;
        JTree tree = this.services.getBrowserComponent().getTreePane().getTree();
        TreePath treePath = tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        BrowserTreeNode browserTreeNode = treeNode = object instanceof BrowserTreeNode ? (BrowserTreeNode)object : null;
        if (treeNode != null) {
            this.updateFilter(tree, treeNode, expand);
        }
    }

    public static /* synthetic */ void updateFilter$default(DetailPane detailPane, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateFilter");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        detailPane.updateFilter(bl);
    }

    protected void updateFilter(@NotNull JTree tree, @NotNull BrowserTreeNode treeNode, boolean expand) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        TreePath selectionPath = treePath;
        treeNode.filterChildren((Function1<? super BrowserTreeNode, Boolean>)((Function1)arg_0 -> DetailPane.updateFilter$lambda$0(this, arg_0)));
        TreeModel treeModel = tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        ((DefaultTreeModel)treeModel).nodeStructureChanged(treeNode);
        if (expand) {
            tree.expandPath(selectionPath);
        }
    }

    protected boolean isChildShown(@NotNull BrowserTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return true;
    }

    @NotNull
    protected final String getConstantPoolEntryName(int constantPoolIndex) {
        String string;
        try {
            string = this.services.getClassFile().getConstantPoolEntryName(constantPoolIndex);
        }
        catch (InvalidByteCodeException ex) {
            string = BrowserBundle.INSTANCE.getString("message.invalid.constant.pool.reference", new Object[0]);
        }
        return string;
    }

    public final void modified() {
        this.services.getBrowserComponent().setModified(true);
        this.services.modified();
        this.refresh();
    }

    protected void refresh() {
    }

    private static final JComponent displayComponent_delegate$lambda$0(DetailPane this$0) {
        this$0.setupComponent();
        return this$0.getWrapper();
    }

    private static final boolean updateFilter$lambda$0(DetailPane this$0, BrowserTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this$0.isChildShown(node);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gjt/jclasslib/browser/DetailPane$Companion;", "", "<init>", "()V", "CPINFO_LINK_TEXT", "", "browser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

