/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.browser.BrowserServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u001a\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gjt/jclasslib/browser/BrowserHistory;", "", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserServices;)V", "undoManager", "Ljavax/swing/undo/UndoManager;", "clear", "", "historyBackward", "historyForward", "updateActions", "addHistoryEntry", "path", "Ljavax/swing/tree/TreePath;", "resetter", "Lorg/gjt/jclasslib/browser/BrowserHistory$Resetter;", "applyingState", "", "BrowserHistoryEntry", "Resetter", "browser"})
public final class BrowserHistory {
    @NotNull
    private final BrowserServices services;
    @NotNull
    private final UndoManager undoManager;
    private boolean applyingState;

    public BrowserHistory(@NotNull BrowserServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        this.services = services;
        this.undoManager = new UndoManager();
    }

    public final void clear() {
        this.undoManager.discardAllEdits();
        this.updateActions();
    }

    public final void historyBackward() {
        this.undoManager.undo();
        this.updateActions();
    }

    public final void historyForward() {
        this.undoManager.redo();
        this.updateActions();
    }

    public final void updateActions() {
        this.services.getBackwardAction().setEnabled(this.undoManager.canUndo());
        this.services.getForwardAction().setEnabled(this.undoManager.canRedo());
    }

    public final void addHistoryEntry(@NotNull TreePath path, @Nullable Resetter resetter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.applyingState) {
            this.undoManager.addEdit(new BrowserHistoryEntry(path, resetter));
            this.updateActions();
        }
    }

    public static /* synthetic */ void addHistoryEntry$default(BrowserHistory browserHistory, TreePath treePath, Resetter resetter, int n, Object object) {
        if ((n & 2) != 0) {
            resetter = null;
        }
        browserHistory.addHistoryEntry(treePath, resetter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0014\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\u0000R\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0018\u00010\u0000R\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gjt/jclasslib/browser/BrowserHistory$BrowserHistoryEntry;", "Ljavax/swing/undo/AbstractUndoableEdit;", "treePath", "Ljavax/swing/tree/TreePath;", "resetter", "Lorg/gjt/jclasslib/browser/BrowserHistory$Resetter;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserHistory;Ljavax/swing/tree/TreePath;Lorg/gjt/jclasslib/browser/BrowserHistory$Resetter;)V", "getTreePath", "()Ljavax/swing/tree/TreePath;", "getResetter", "()Lorg/gjt/jclasslib/browser/BrowserHistory$Resetter;", "before", "Lorg/gjt/jclasslib/browser/BrowserHistory;", "canUndo", "", "toString", "", "addEdit", "newEdit", "Ljavax/swing/undo/UndoableEdit;", "replaceEdit", "lastEdit", "isEditMoreSpecificThan", "otherEdit", "undo", "", "redo", "applyState", "browser"})
    private final class BrowserHistoryEntry
    extends AbstractUndoableEdit {
        @NotNull
        private final TreePath treePath;
        @Nullable
        private final Resetter resetter;
        @Nullable
        private BrowserHistoryEntry before;

        public BrowserHistoryEntry(@Nullable TreePath treePath, Resetter resetter) {
            Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
            this.treePath = treePath;
            this.resetter = resetter;
        }

        @NotNull
        public final TreePath getTreePath() {
            return this.treePath;
        }

        @Nullable
        public final Resetter getResetter() {
            return this.resetter;
        }

        @Override
        public boolean canUndo() {
            return this.before != null;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.treePath.toString();
            Object object = this.resetter;
            if (object == null || (object = object.toString()) == null) {
                object = "null";
            }
            return string + " / " + (String)object;
        }

        @Override
        public boolean addEdit(@NotNull UndoableEdit newEdit) {
            Intrinsics.checkNotNullParameter((Object)newEdit, (String)"newEdit");
            if (!(newEdit instanceof BrowserHistoryEntry)) {
                return true;
            }
            if (this.isEditMoreSpecificThan((BrowserHistoryEntry)newEdit)) {
                return true;
            }
            ((BrowserHistoryEntry)newEdit).before = this;
            return false;
        }

        @Override
        public boolean replaceEdit(@NotNull UndoableEdit lastEdit) {
            Intrinsics.checkNotNullParameter((Object)lastEdit, (String)"lastEdit");
            if (!(lastEdit instanceof BrowserHistoryEntry)) {
                return false;
            }
            if (this.isEditMoreSpecificThan((BrowserHistoryEntry)lastEdit)) {
                this.before = ((BrowserHistoryEntry)lastEdit).before;
                return true;
            }
            return false;
        }

        private final boolean isEditMoreSpecificThan(BrowserHistoryEntry otherEdit) {
            return Intrinsics.areEqual((Object)otherEdit.treePath, (Object)this.treePath) && otherEdit.resetter == null;
        }

        @Override
        public void undo() {
            block0: {
                super.undo();
                BrowserHistoryEntry browserHistoryEntry = this.before;
                if (browserHistoryEntry == null) break block0;
                browserHistoryEntry.applyState();
            }
        }

        @Override
        public void redo() {
            super.redo();
            this.applyState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void applyState() {
            BrowserHistory.this.applyingState = true;
            try {
                JTree jTree;
                JTree $this$applyState_u24lambda_u240 = jTree = BrowserHistory.this.services.getBrowserComponent().getTreePane().getTree();
                boolean bl = false;
                $this$applyState_u24lambda_u240.setSelectionPath(this.treePath);
                $this$applyState_u24lambda_u240.scrollPathToVisible(this.treePath);
                Resetter resetter = this.resetter;
                if (resetter != null) {
                    resetter.reset();
                }
                BrowserHistory.this.updateActions();
            }
            finally {
                BrowserHistory.this.applyingState = false;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/gjt/jclasslib/browser/BrowserHistory$Resetter;", "", "reset", "", "browser"})
    public static interface Resetter {
        public void reset();
    }
}

