/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.process.internal;

import io.matthewnelson.encoding.core.util.TextUtil;
import io.matthewnelson.kmp.process.Output;
import io.matthewnelson.kmp.process.OutputFeed;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0010\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0011J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016R \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068A@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068A@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038A@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/kmp/process/internal/OutputFeedBuffer;", "Lio/matthewnelson/kmp/process/OutputFeed;", "maxSize", "", "(I)V", "<set-?>", "", "hasEnded", "()Z", "lines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "maxSizeExceeded", "size", "()I", "doFinal", "doFinal$io_matthewnelson_kmp_process_process_jvm", "onOutput", "", "line", "Companion", "io.matthewnelson.kmp-process_process_jvm"})
@SourceDebugExtension(value={"SMAP\n-OutputFeedBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -OutputFeedBuffer.kt\nio/matthewnelson/kmp/process/internal/OutputFeedBuffer\n+ 2 TextUtil.kt\nio/matthewnelson/encoding/core/util/TextUtil\n*L\n1#1,96:1\n34#2:97\n*S KotlinDebug\n*F\n+ 1 -OutputFeedBuffer.kt\nio/matthewnelson/kmp/process/internal/OutputFeedBuffer\n*L\n80#1:97\n*E\n"})
public final class OutputFeedBuffer
implements OutputFeed {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private final ArrayList<String> lines;
    private volatile int size;
    private volatile boolean hasEnded;
    private volatile boolean maxSizeExceeded;

    private OutputFeedBuffer(int maxSize) {
        this.maxSize = RangesKt.coerceAtLeast((int)maxSize, (int)1);
        this.lines = new ArrayList(20);
    }

    @JvmName(name="size")
    public final int size() {
        return this.size;
    }

    @JvmName(name="hasEnded")
    public final boolean hasEnded() {
        return this.hasEnded;
    }

    @JvmName(name="maxSizeExceeded")
    public final boolean maxSizeExceeded() {
        return this.maxSizeExceeded;
    }

    @Override
    public void onOutput(@Nullable String line) {
        if (line == null) {
            this.hasEnded = true;
            return;
        }
        if (this.maxSizeExceeded) {
            return;
        }
        int newLineChar = !((Collection)this.lines).isEmpty() ? 1 : 0;
        int remaining = this.maxSize - this.size - newLineChar;
        if (newLineChar + line.length() > remaining) {
            this.maxSizeExceeded = true;
            if (((CharSequence)line).length() == 0) {
                this.lines.add(line);
                this.size += newLineChar;
                return;
            }
            String truncate = StringsKt.take((String)line, (int)remaining);
            this.lines.add(truncate);
            this.size += newLineChar + truncate.length();
        } else {
            this.lines.add(line);
            this.size += newLineChar + line.length();
        }
    }

    @NotNull
    public final String doFinal$io_matthewnelson_kmp_process_process_jvm() {
        StringBuilder sb = new StringBuilder(this.size);
        CollectionsKt.joinTo$default((Iterable)this.lines, (Appendable)sb, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
        this.lines.clear();
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        StringBuilder $this$wipe$iv = sb;
        boolean $i$f$wipe = false;
        TextUtil.wipe((StringBuilder)$this$wipe$iv, (int)$this$wipe$iv.length());
        this.size = 0;
        this.hasEnded = false;
        this.maxSizeExceeded = false;
        return result;
    }

    public /* synthetic */ OutputFeedBuffer(int maxSize, DefaultConstructorMarker $constructor_marker) {
        this(maxSize);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\n"}, d2={"Lio/matthewnelson/kmp/process/internal/OutputFeedBuffer$Companion;", "", "()V", "of", "Lio/matthewnelson/kmp/process/internal/OutputFeedBuffer;", "options", "Lio/matthewnelson/kmp/process/Output$Options;", "of$io_matthewnelson_kmp_process_process_jvm", "maxSize", "", "io.matthewnelson.kmp-process_process_jvm"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ OutputFeedBuffer of$io_matthewnelson_kmp_process_process_jvm(int maxSize) {
            return new OutputFeedBuffer(maxSize, null);
        }

        public final /* synthetic */ OutputFeedBuffer of$io_matthewnelson_kmp_process_process_jvm(Output.Options options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new OutputFeedBuffer(options.getMaxBuffer$io_matthewnelson_kmp_process_process_jvm(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

