/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.core.util;

import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.MalformedEncodingException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0006\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/core/util/FeedBuffer;", "", "blockSize", "", "flush", "Lio/matthewnelson/encoding/core/util/FeedBuffer$Flush;", "finalize", "Lio/matthewnelson/encoding/core/util/FeedBuffer$Finalize;", "(ILio/matthewnelson/encoding/core/util/FeedBuffer$Flush;Lio/matthewnelson/encoding/core/util/FeedBuffer$Finalize;)V", "buffer", "", "<set-?>", "count", "()I", "", "update", "input", "Companion", "Finalize", "Flush", "io.matthewnelson.encoding_core_jvm"})
@SourceDebugExtension(value={"SMAP\nFeedBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedBuffer.kt\nio/matthewnelson/encoding/core/util/FeedBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public abstract class FeedBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int blockSize;
    @NotNull
    private final Flush flush;
    @NotNull
    private final Finalize finalize;
    private int count;
    @NotNull
    private final int[] buffer;

    public FeedBuffer(int blockSize, @NotNull Flush flush, @NotNull Finalize finalize) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)flush, (String)"flush");
        Intrinsics.checkNotNullParameter((Object)finalize, (String)"finalize");
        this.blockSize = blockSize;
        this.flush = flush;
        this.finalize = finalize;
        if (!(this.blockSize > 0)) {
            boolean bl = false;
            String string = "blockSize must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.buffer = new int[this.blockSize];
    }

    @JvmName(name="count")
    public final int count() {
        return this.count;
    }

    public final void update(int input) {
        int n = this.count;
        this.count = n + 1;
        this.buffer[n] = input;
        if (this.count != this.blockSize) {
            return;
        }
        this.flush.invoke(this.buffer);
        this.count = 0;
    }

    public final void finalize() {
        ArraysKt.fill$default((int[])this.buffer, (int)0, (int)this.count, (int)0, (int)4, null);
        this.finalize.invoke(this.count % this.blockSize, this.buffer);
        ArraysKt.fill((int[])this.buffer, (int)0, (int)0, (int)this.count);
        this.count = 0;
    }

    @JvmStatic
    @NotNull
    public static final EncodingException truncatedInputEncodingException(int modulus) {
        return Companion.truncatedInputEncodingException(modulus);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lio/matthewnelson/encoding/core/util/FeedBuffer$Companion;", "", "()V", "truncatedInputEncodingException", "Lio/matthewnelson/encoding/core/EncodingException;", "modulus", "", "io.matthewnelson.encoding_core_jvm"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EncodingException truncatedInputEncodingException(int modulus) {
            return new MalformedEncodingException("Truncated input. Illegal Modulus[" + modulus + ']');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/core/util/FeedBuffer$Finalize;", "", "invoke", "", "modulus", "", "buffer", "", "io.matthewnelson.encoding_core_jvm"})
    public static interface Finalize {
        public void invoke(int var1, @NotNull int[] var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/matthewnelson/encoding/core/util/FeedBuffer$Flush;", "", "invoke", "", "buffer", "", "io.matthewnelson.encoding_core_jvm"})
    public static interface Flush {
        public void invoke(@NotNull int[] var1);
    }
}

