/*
 * Decompiled with CFR 0.152.
 */
package net.jafama;

public final class NumbersUtils {
    public static final double DOUBLE_MIN_NORMAL;
    public static final float FLOAT_MIN_NORMAL;
    private static final char[] CHAR_BY_DIGIT;
    private static final int[] DIV_SHIFT_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX;
    private static final double PIO2_HI;
    private static final double PIO2_LO;
    private static final double PI_HI;
    private static final double PI_LO;
    private static final double TWOPI_HI;
    private static final double TWOPI_LO;

    public static double twoPow(int power) {
        if (power <= -1023) {
            if (power >= -1074) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return 0.0;
        }
        if (power > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    static {
        int c;
        DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
        FLOAT_MIN_NORMAL = Float.intBitsToFloat(0x800000);
        int minDecimal = 48;
        int maxDecimal = 57;
        int n1 = 10;
        int minLetter = 65;
        int maxLetter = 90;
        int n2 = 26;
        CHAR_BY_DIGIT = new char[36];
        int i = 0;
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            NumbersUtils.CHAR_BY_DIGIT[i++] = c;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            NumbersUtils.CHAR_BY_DIGIT[i++] = c;
        }
        DIV_SHIFT_BY_RADIX = new int[33];
        int shift = 1;
        for (int radix = 2; radix <= 32; radix *= 2) {
            NumbersUtils.DIV_SHIFT_BY_RADIX[radix] = shift++;
        }
        MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX = new int[37];
        MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX = new int[37];
        for (int radix = 2; radix <= 36; ++radix) {
            NumbersUtils.MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX[radix] = Integer.toString(Integer.MIN_VALUE, radix).length() - 1;
            NumbersUtils.MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX[radix] = Long.toString(Long.MIN_VALUE, radix).length() - 1;
        }
        PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
        PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
        PI_HI = 2.0 * PIO2_HI;
        PI_LO = 2.0 * PIO2_LO;
        TWOPI_HI = 4.0 * PIO2_HI;
        TWOPI_LO = 4.0 * PIO2_LO;
    }
}

