/*
 * Decompiled with CFR 0.152.
 */
package net.jafama;

import net.jafama.CmnFastMath;

public final class FastMath
extends CmnFastMath {
    private static final boolean USE_JDK_MATH = FM_USE_JDK_MATH;
    private static final boolean USE_REDEFINED_LOG = FM_USE_REDEFINED_LOG;
    private static final boolean USE_REDEFINED_SQRT = FM_USE_REDEFINED_SQRT;

    public static double sin(double angle) {
        if (USE_JDK_MATH) {
            return Math.sin(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            long remAndQuad = FastMath.remainderPiO2(angle);
            angle = FastMath.decodeRemainder(remAndQuad);
            int q = FastMath.decodeQuadrant(remAndQuad);
            double sin = q == 0 ? FastMath.sin(angle) : (q == 1 ? FastMath.cos(angle) : (q == 2 ? -FastMath.sin(angle) : -FastMath.cos(angle)));
            return negateResult ? -sin : sin;
        }
        int index = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexSin = CmnFastMath.MyTSinCos.sinTab[index &= SIN_COS_TABS_SIZE - 2];
        double indexCos = CmnFastMath.MyTSinCos.cosTab[index];
        double result = indexSin + delta * (indexCos + delta * (-indexSin * 0.5 + delta * (-indexCos * 0.16666666666666666 + delta * indexSin * 0.041666666666666664)));
        return negateResult ? -result : result;
    }

    public static double cos(double angle) {
        if (USE_JDK_MATH) {
            return Math.cos(angle);
        }
        if ((angle = Math.abs(angle)) > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            long remAndQuad = FastMath.remainderPiO2(angle);
            angle = FastMath.decodeRemainder(remAndQuad);
            int q = FastMath.decodeQuadrant(remAndQuad);
            double cos = q == 0 ? FastMath.cos(angle) : (q == 1 ? -FastMath.sin(angle) : (q == 2 ? -FastMath.cos(angle) : FastMath.sin(angle)));
            return cos;
        }
        int index = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexCos = CmnFastMath.MyTSinCos.cosTab[index &= SIN_COS_TABS_SIZE - 2];
        double indexSin = CmnFastMath.MyTSinCos.sinTab[index];
        return indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public static double tanh(double value) {
        double z;
        if (USE_JDK_MATH) {
            return Math.tanh(value);
        }
        boolean negateResult = false;
        if (value < 0.0) {
            value = -value;
            negateResult = true;
        }
        if (value < 19.061547465398498) {
            if (value < TWO_POW_N55) {
                return negateResult ? -value * (1.0 - value) : value * (1.0 + value);
            }
            if (value >= 1.0) {
                z = 1.0 - 2.0 / (FastMath.expm1(value + value) + 2.0);
            } else {
                double t = FastMath.expm1(-(value + value));
                z = -t / (t + 2.0);
            }
        } else {
            z = value != value ? Double.NaN : 1.0;
        }
        return negateResult ? -z : z;
    }

    public static double exp(double value) {
        if (USE_JDK_MATH) {
            return Math.exp(value);
        }
        if (value > EXP_OVERFLOW_LIMIT) {
            return Double.POSITIVE_INFINITY;
        }
        if (!(value >= EXP_UNDERFLOW_LIMIT)) {
            return value != value ? Double.NaN : 0.0;
        }
        int indexes = (int)(value * (double)EXP_LO_INDEXING);
        int valueInt = indexes >= 0 ? indexes >> EXP_LO_INDEXING_DIV_SHIFT : -(-indexes >> EXP_LO_INDEXING_DIV_SHIFT);
        double hiTerm = CmnFastMath.MyTExp.expHiTab[valueInt - (int)EXP_UNDERFLOW_LIMIT];
        int zIndex = indexes - (valueInt << EXP_LO_INDEXING_DIV_SHIFT);
        double y = value - (double)valueInt;
        double z = (double)zIndex * (1.0 / (double)EXP_LO_INDEXING);
        double eps = y - z;
        double expZ = CmnFastMath.MyTExp.expLoPosTab[zIndex + EXP_LO_TAB_MID_INDEX];
        double expEps = 1.0 + eps * (1.0 + eps * (0.5 + eps * (0.16666666666666666 + eps * 0.041666666666666664)));
        double loTerm = expZ * expEps;
        return hiTerm * loTerm;
    }

    public static double expm1(double value) {
        if (USE_JDK_MATH) {
            return Math.expm1(value);
        }
        if (Math.abs(value) < 1.0) {
            int i = (int)(value * (double)EXP_LO_INDEXING);
            double delta = value - (double)i * (1.0 / (double)EXP_LO_INDEXING);
            return CmnFastMath.MyTExp.expLoPosTab[i + EXP_LO_TAB_MID_INDEX] * (CmnFastMath.MyTExp.expLoNegTab[i + EXP_LO_TAB_MID_INDEX] + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * (0.041666666666666664 + delta * 0.008333333333333333)))));
        }
        return FastMath.exp(value) - 1.0;
    }

    public static double log(double value) {
        if (USE_JDK_MATH || !USE_REDEFINED_LOG) {
            return Math.log(value);
        }
        if (value > 0.0) {
            double h;
            if (value == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            if (value > 0.95) {
                if (value < 1.14) {
                    double z = (value - 1.0) / (value + 1.0);
                    double z2 = z * z;
                    return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                }
                h = 0.0;
            } else if (value < DOUBLE_MIN_NORMAL) {
                value *= TWO_POW_52;
                h = -52.0 * LOG_2;
            } else {
                h = 0.0;
            }
            int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
            int valueExp = (valueBitsHi >> 20) - 1023;
            int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
            double z = value * FastMath.twoPowNormalOrSubnormal(-valueExp) * CmnFastMath.MyTLog.logXInvTab[xIndex] - 1.0;
            z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
            return h + (double)valueExp * LOG_2 + (CmnFastMath.MyTLog.logXLogTab[xIndex] + z);
        }
        if (value == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static double pow(double value, double power) {
        if (USE_JDK_MATH) {
            return Math.pow(value, power);
        }
        if (power == 0.0) {
            return 1.0;
        }
        if (power == 1.0) {
            return value;
        }
        if (value <= 0.0) {
            int powerInfo;
            if (Math.abs(power) >= TWO_POW_52 * 2.0) {
                powerInfo = 1;
            } else if (Math.abs(power) <= 2.147483647E9) {
                int powerAsInt = (int)power;
                powerInfo = power == (double)powerAsInt ? ((powerAsInt & 1) == 0 ? 1 : -1) : 0;
            } else {
                long powerAsLong = (long)power;
                if (power == (double)powerAsLong) {
                    powerInfo = (powerAsLong & 1L) == 0L ? 1 : -1;
                } else {
                    if (power != power) {
                        return Double.NaN;
                    }
                    powerInfo = 0;
                }
            }
            if (value == 0.0) {
                if (power < 0.0) {
                    return powerInfo < 0 ? 1.0 / value : Double.POSITIVE_INFINITY;
                }
                return powerInfo < 0 ? value : 0.0;
            }
            if (value == Double.NEGATIVE_INFINITY) {
                if (powerInfo < 0) {
                    return power < 0.0 ? -0.0 : Double.NEGATIVE_INFINITY;
                }
                return power < 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            return powerInfo == 0 ? Double.NaN : (double)powerInfo * FastMath.exp(power * FastMath.log(-value));
        }
        return FastMath.exp(power * FastMath.log(value));
    }

    public static double sqrt(double value) {
        double h;
        if (USE_JDK_MATH || !USE_REDEFINED_SQRT) {
            return Math.sqrt(value);
        }
        if (!(value > 0.0)) {
            return value < 0.0 ? Double.NaN : value;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (value < DOUBLE_MIN_NORMAL) {
            value *= TWO_POW_52;
            h = 2.0 * TWO_POW_N26;
        } else {
            h = 2.0;
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
        int valueExponentIndex = (valueBitsHi >> 20) + 51;
        int xIndex = valueBitsHi << 12 >>> 32 - SQRT_LO_BITS;
        double result = CmnFastMath.MyTSqrt.sqrtXSqrtHiTab[valueExponentIndex] * CmnFastMath.MyTSqrt.sqrtXSqrtLoTab[xIndex];
        double slope = CmnFastMath.MyTSqrt.sqrtSlopeHiTab[valueExponentIndex] * CmnFastMath.MyTSqrt.sqrtSlopeLoTab[xIndex];
        result += ((value *= 0.25) - result * result) * slope;
        result += (value - result * result) * slope;
        return h * (result + (value - result * result) * slope);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    private static long remainderPiO2(double angle) {
        if (USE_JDK_MATH) {
            return FastMath.jdkRemainderPiO2(angle, false);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle <= NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2) {
            int n = (int)(angle * PIO2_INV + 0.5);
            double fn = n;
            if ((angle = angle - fn * PIO2_HI - fn * PIO2_LO) < -0.7853981633974483) {
                angle = angle + PIO2_HI + PIO2_LO;
                --n;
            } else if (angle > 0.7853981633974483) {
                angle = angle - PIO2_HI - PIO2_LO;
                ++n;
            }
            if (negateResult) {
                angle = -angle;
            }
            return FastMath.encodeRemainderAndQuadrant(angle, n & 3);
        }
        if (angle < Double.POSITIVE_INFINITY) {
            return FastMath.heavyRemainderPiO2(angle, negateResult);
        }
        return FastMath.encodeRemainderAndQuadrant(Double.NaN, 0);
    }
}

