/*
 * Decompiled with CFR 0.152.
 */
package jinjava.org.jsoup.safety;

import jinjava.org.jsoup.helper.Validate;
import jinjava.org.jsoup.nodes.Attribute;
import jinjava.org.jsoup.nodes.Attributes;
import jinjava.org.jsoup.nodes.DataNode;
import jinjava.org.jsoup.nodes.Document;
import jinjava.org.jsoup.nodes.Element;
import jinjava.org.jsoup.nodes.Node;
import jinjava.org.jsoup.nodes.TextNode;
import jinjava.org.jsoup.parser.Tag;
import jinjava.org.jsoup.safety.Safelist;
import jinjava.org.jsoup.select.NodeTraversor;
import jinjava.org.jsoup.select.NodeVisitor;

public class Cleaner {
    private final Safelist safelist;

    public Cleaner(Safelist safelist) {
        Validate.notNull(safelist);
        this.safelist = safelist;
    }

    public Document clean(Document dirtyDocument) {
        Validate.notNull(dirtyDocument);
        Document clean = Document.createShell(dirtyDocument.baseUri());
        this.copySafeNodes(dirtyDocument.body(), clean.body());
        clean.outputSettings(dirtyDocument.outputSettings().clone());
        return clean;
    }

    private int copySafeNodes(Element source, Element dest) {
        CleaningVisitor cleaningVisitor = new CleaningVisitor(source, dest);
        NodeTraversor.traverse((NodeVisitor)cleaningVisitor, source);
        return cleaningVisitor.numDiscarded;
    }

    private ElementMeta createSafeElement(Element sourceEl) {
        String sourceTag = sourceEl.tagName();
        Attributes destAttrs = new Attributes();
        Element dest = new Element(Tag.valueOf(sourceTag), sourceEl.baseUri(), destAttrs);
        int numDiscarded = 0;
        Attributes sourceAttrs = sourceEl.attributes();
        for (Attribute sourceAttr : sourceAttrs) {
            if (this.safelist.isSafeAttribute(sourceTag, sourceEl, sourceAttr)) {
                destAttrs.put(sourceAttr);
                continue;
            }
            ++numDiscarded;
        }
        Attributes enforcedAttrs = this.safelist.getEnforcedAttributes(sourceTag);
        destAttrs.addAll(enforcedAttrs);
        if (sourceEl.sourceRange().isTracked()) {
            sourceEl.sourceRange().track(dest, true);
        }
        if (sourceEl.endSourceRange().isTracked()) {
            sourceEl.endSourceRange().track(dest, false);
        }
        return new ElementMeta(dest, numDiscarded);
    }

    private static class ElementMeta {
        Element el;
        int numAttribsDiscarded;

        ElementMeta(Element el, int numAttribsDiscarded) {
            this.el = el;
            this.numAttribsDiscarded = numAttribsDiscarded;
        }
    }

    private final class CleaningVisitor
    implements NodeVisitor {
        private int numDiscarded = 0;
        private final Element root;
        private Element destination;

        private CleaningVisitor(Element root, Element destination) {
            this.root = root;
            this.destination = destination;
        }

        @Override
        public void head(Node source, int depth) {
            if (source instanceof Element) {
                Element sourceEl = (Element)source;
                if (Cleaner.this.safelist.isSafeTag(sourceEl.normalName())) {
                    ElementMeta meta = Cleaner.this.createSafeElement(sourceEl);
                    Element destChild = meta.el;
                    this.destination.appendChild(destChild);
                    this.numDiscarded += meta.numAttribsDiscarded;
                    this.destination = destChild;
                } else if (source != this.root) {
                    ++this.numDiscarded;
                }
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                TextNode destText = new TextNode(sourceText.getWholeText());
                this.destination.appendChild(destText);
            } else if (source instanceof DataNode && Cleaner.this.safelist.isSafeTag(source.parent().nodeName())) {
                DataNode sourceData = (DataNode)source;
                DataNode destData = new DataNode(sourceData.getWholeData());
                this.destination.appendChild(destData);
            } else {
                ++this.numDiscarded;
            }
        }

        @Override
        public void tail(Node source, int depth) {
            if (source instanceof Element && Cleaner.this.safelist.isSafeTag(source.nodeName())) {
                this.destination = this.destination.parent();
            }
        }
    }
}

