/*
 * Decompiled with CFR 0.152.
 */
package jinjava.org.jsoup.nodes;

import java.io.IOException;
import jinjava.org.jsoup.internal.StringUtil;
import jinjava.org.jsoup.nodes.Document;
import jinjava.org.jsoup.nodes.Element;
import jinjava.org.jsoup.nodes.Entities;
import jinjava.org.jsoup.nodes.LeafNode;
import jinjava.org.jsoup.nodes.Node;

public class TextNode
extends LeafNode {
    public TextNode(String text) {
        this.value = text;
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String text) {
        this.coreValue(text);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        boolean prettyPrint = out.prettyPrint();
        Element parent = this.parentNode instanceof Element ? (Element)this.parentNode : null;
        boolean normaliseWhite = prettyPrint && !Element.preserveWhitespace(this.parentNode);
        boolean trimLeading = false;
        boolean trimTrailing = false;
        if (normaliseWhite) {
            boolean couldSkip;
            trimLeading = this.siblingIndex == 0 && parent != null && parent.tag().isBlock() || this.parentNode instanceof Document;
            trimTrailing = this.nextSibling() == null && parent != null && parent.tag().isBlock();
            Node next = this.nextSibling();
            boolean bl = couldSkip = next instanceof Element && ((Element)next).shouldIndent(out) || next instanceof TextNode && ((TextNode)next).isBlank();
            if (couldSkip && this.isBlank()) {
                return;
            }
            if (this.siblingIndex == 0 && parent != null && parent.tag().formatAsBlock() && !this.isBlank() || out.outline() && this.siblingNodes().size() > 0 && !this.isBlank()) {
                this.indent(accum, depth, out);
            }
        }
        Entities.escape(accum, this.coreValue(), out, false, normaliseWhite, trimLeading, trimTrailing);
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        return sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ';
    }
}

