/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;

public class ToolProviderRequest {
    private final InvocationContext invocationContext;
    private final UserMessage userMessage;

    public ToolProviderRequest(Builder builder) {
        this.invocationContext = ValidationUtils.ensureNotNull(builder.invocationContext, "invocationContext");
        this.userMessage = ValidationUtils.ensureNotNull(builder.userMessage, "userMessage");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InvocationContext invocationContext;
        private UserMessage userMessage;

        public Builder invocationContext(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
            return this;
        }

        public Builder userMessage(UserMessage userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public ToolProviderRequest build() {
            return new ToolProviderRequest(this);
        }
    }
}

