/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.ParsingUtils;
import dev.langchain4j.service.output.PojoOutputParser;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Supplier;

abstract class PojoCollectionOutputParser<T, CT extends Collection<T>>
implements OutputParser<CT> {
    private final Class<T> type;
    private final PojoOutputParser<T> parser;

    PojoCollectionOutputParser(Class<T> type) {
        this.type = ValidationUtils.ensureNotNull(type, "type");
        this.parser = new PojoOutputParser<T>(type);
    }

    @Override
    public CT parse(String text) {
        return ParsingUtils.parseAsStringOrJson(text, this.parser::parse, this.emptyCollectionSupplier(), this.type());
    }

    abstract Supplier<CT> emptyCollectionSupplier();

    private String type() {
        return this.collectionType().getName() + "<" + this.type.getName() + ">";
    }

    abstract Class<?> collectionType();

    @Override
    public Optional<JsonSchema> jsonSchema() {
        JsonSchema jsonSchema = JsonSchema.builder().name(this.collectionType().getSimpleName() + "_of_" + this.type.getSimpleName()).rootElement(JsonObjectSchema.builder().addProperty("values", JsonArraySchema.builder().items(JsonSchemaElementUtils.jsonObjectOrReferenceSchemaFrom(this.type, null, false, new LinkedHashMap(), true)).build()).required("values").build()).build();
        return Optional.of(jsonSchema);
    }

    @Override
    public String formatInstructions() {
        throw new IllegalStateException();
    }
}

