/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.memory;

import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import java.util.Map;

public class ChatMemoryService {
    private ChatMemory defaultChatMemory;
    private Map<Object, ChatMemory> chatMemories;
    private ChatMemoryProvider chatMemoryProvider;

    public ChatMemory getOrCreateChatMemory(Object memoryId) {
        if (memoryId == "default") {
            if (this.defaultChatMemory == null) {
                this.defaultChatMemory = this.chatMemoryProvider.get("default");
            }
            return this.defaultChatMemory;
        }
        return this.chatMemories.computeIfAbsent(memoryId, this.chatMemoryProvider::get);
    }

    public ChatMemory getChatMemory(Object memoryId) {
        return memoryId == "default" ? this.defaultChatMemory : this.chatMemories.get(memoryId);
    }

    public ChatMemory evictChatMemory(Object memoryId) {
        return this.chatMemories.remove(memoryId);
    }
}

