/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.tool.ToolExecution;
import java.util.List;

public class Result<T> {
    private final T content;
    private final TokenUsage tokenUsage;
    private final List<Object> sources;
    private final FinishReason finishReason;
    private final List<ToolExecution> toolExecutions;
    private final List<ChatResponse> intermediateResponses;
    private final ChatResponse finalResponse;

    public Result(ResultBuilder<T> builder) {
        this.content = builder.content;
        this.tokenUsage = builder.tokenUsage;
        this.sources = Utils.copy(builder.sources);
        this.finishReason = builder.finishReason;
        this.toolExecutions = Utils.copy(builder.toolExecutions);
        this.intermediateResponses = Utils.copy(builder.intermediateResponses);
        this.finalResponse = builder.finalResponse;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public static class ResultBuilder<T> {
        private T content;
        private TokenUsage tokenUsage;
        private List<Object> sources;
        private FinishReason finishReason;
        private List<ToolExecution> toolExecutions;
        private List<ChatResponse> intermediateResponses;
        private ChatResponse finalResponse;

        ResultBuilder() {
        }

        public ResultBuilder<T> content(T content) {
            this.content = content;
            return this;
        }

        public ResultBuilder<T> tokenUsage(TokenUsage tokenUsage) {
            this.tokenUsage = tokenUsage;
            return this;
        }

        public ResultBuilder<T> sources(List<Object> sources) {
            this.sources = sources;
            return this;
        }

        public ResultBuilder<T> finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public ResultBuilder<T> toolExecutions(List<ToolExecution> toolExecutions) {
            this.toolExecutions = toolExecutions;
            return this;
        }

        public ResultBuilder<T> intermediateResponses(List<ChatResponse> intermediateResponses) {
            this.intermediateResponses = intermediateResponses;
            return this;
        }

        public ResultBuilder<T> finalResponse(ChatResponse finalResponse) {
            this.finalResponse = finalResponse;
            return this;
        }

        public Result<T> build() {
            return new Result(this);
        }
    }
}

