/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.Exceptions;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class VirtualThreadUtils {
    private static Method newVirtualThreadPerTaskExecutorMethod;
    private static Method isVirtualMethod;

    public static ExecutorService createVirtualThreadExecutor(Supplier<ExecutorService> fallback) {
        try {
            if (newVirtualThreadPerTaskExecutorMethod != null) {
                return (ExecutorService)newVirtualThreadPerTaskExecutorMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtime("Failed to create virtual thread executor", e);
        }
        if (fallback == null) {
            return null;
        }
        return fallback.get();
    }

    static {
        try {
            newVirtualThreadPerTaskExecutorMethod = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
            isVirtualMethod = Thread.class.getMethod("isVirtual", new Class[0]);
        }
        catch (Exception e) {
            newVirtualThreadPerTaskExecutorMethod = null;
            isVirtualMethod = null;
        }
    }
}

