/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class ImageContent
implements Content {
    private final Image image;
    private final DetailLevel detailLevel;

    public ImageContent(Image image) {
        this(image, DetailLevel.LOW);
    }

    public ImageContent(Image image, DetailLevel detailLevel) {
        this.image = ValidationUtils.ensureNotNull(image, "image");
        this.detailLevel = ValidationUtils.ensureNotNull(detailLevel, "detailLevel");
    }

    @Override
    public ContentType type() {
        return ContentType.IMAGE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageContent that = (ImageContent)o;
        return Objects.equals(this.image, that.image) && Objects.equals((Object)this.detailLevel, (Object)that.detailLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.detailLevel});
    }

    public String toString() {
        return "ImageContent { image = " + String.valueOf(this.image) + " detailLevel = " + String.valueOf((Object)this.detailLevel) + " }";
    }

    public static ImageContent from(Image image) {
        return new ImageContent(image);
    }

    public static enum DetailLevel {
        LOW,
        MEDIUM,
        HIGH,
        ULTRA_HIGH,
        AUTO;

    }
}

