/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MissingEndTagException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnexpectedTokenException;
import com.hubspot.jinjava.interpret.UnknownTagException;
import com.hubspot.jinjava.lib.tag.EndTag;
import com.hubspot.jinjava.lib.tag.FlexibleTag;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.RootNode;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.TextNode;
import com.hubspot.jinjava.tree.parse.ExpressionToken;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.TextToken;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScanner;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.tree.parse.UnclosedToken;
import org.apache.commons.lang3.StringUtils;

public class TreeParser {
    private final PeekingIterator<Token> scanner;
    private final JinjavaInterpreter interpreter;
    private final TokenScannerSymbols symbols;
    private Node parent;

    public TreeParser(JinjavaInterpreter interpreter, String input) {
        this.scanner = Iterators.peekingIterator(new TokenScanner(input, interpreter.getConfig()));
        this.interpreter = interpreter;
        this.symbols = interpreter.getConfig().getTokenScannerSymbols();
    }

    public Node buildTree() {
        RootNode root = new RootNode(this.symbols);
        this.parent = root;
        while (this.scanner.hasNext()) {
            Node node = this.nextNode();
            if (node == null) continue;
            if (node instanceof TextNode && this.getLastSibling() instanceof TextNode && !this.interpreter.getConfig().getLegacyOverrides().isAllowAdjacentTextNodes()) {
                ((TextToken)this.getLastSibling().getMaster()).mergeImageAndContent((TextToken)node.getMaster());
                continue;
            }
            this.parent.getChildren().add(node);
        }
        do {
            if (this.parent == root) continue;
            this.interpreter.addError(TemplateError.fromException(new MissingEndTagException(((TagNode)this.parent).getEndName(), this.parent.getMaster().getImage(), this.parent.getLineNumber(), this.parent.getStartPosition())));
            this.parent = this.parent.getParent();
        } while (this.parent.getParent() != null);
        return root;
    }

    private Node nextNode() {
        Node lastSibling;
        Token token = this.scanner.next();
        if (token.isLeftTrim() && this.isTrimmingEnabledForToken(token, this.interpreter.getConfig()) && (lastSibling = this.getLastSibling()) instanceof TextNode) {
            lastSibling.getMaster().setRightTrim(true);
        }
        if (token.getType() == this.symbols.getFixed()) {
            if (token instanceof UnclosedToken) {
                this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Unclosed token", "token", token.getLineNumber(), token.getStartPosition(), null));
            }
            return this.text((TextToken)token);
        }
        if (token.getType() == this.symbols.getExprStart()) {
            return this.expression((ExpressionToken)token);
        }
        if (token.getType() == this.symbols.getTag()) {
            return this.tag((TagToken)token);
        }
        if (token.getType() == this.symbols.getNote()) {
            String commentClosed = this.symbols.getClosingComment();
            if (!token.getImage().endsWith(commentClosed)) {
                this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Unclosed comment", "comment", token.getLineNumber(), token.getStartPosition(), null));
            }
        } else {
            this.interpreter.addError(TemplateError.fromException(new UnexpectedTokenException(token.getImage(), token.getLineNumber(), token.getStartPosition())));
        }
        return null;
    }

    private Node getLastSibling() {
        if (this.parent == null || this.parent.getChildren().isEmpty()) {
            return null;
        }
        return this.parent.getChildren().getLast();
    }

    private Node text(TextToken textToken) {
        Node lastSibling;
        if (this.interpreter.getConfig().isLstripBlocks() && this.scanner.hasNext() && this.scanner.peek().getType() == this.symbols.getTag()) {
            textToken = new TextToken(StringUtils.stripEnd(textToken.getImage(), "\t "), textToken.getLineNumber(), textToken.getStartPosition(), this.symbols);
        }
        if ((lastSibling = this.getLastSibling()) != null && this.isRightTrim(lastSibling) && this.isTrimmingEnabledForToken(lastSibling.getMaster(), this.interpreter.getConfig())) {
            textToken.setLeftTrim(true);
        }
        if (this.parent instanceof TagNode && lastSibling == null && this.parent.getMaster().isRightTrim()) {
            textToken.setLeftTrim(true);
        }
        TextNode n = new TextNode(textToken);
        n.setParent(this.parent);
        return n;
    }

    private boolean isRightTrim(Node lastSibling) {
        if (lastSibling instanceof TagNode) {
            return ((TagNode)lastSibling).getEndName() == null || ((TagNode)lastSibling).getTag() instanceof FlexibleTag && !((FlexibleTag)((Object)((TagNode)lastSibling).getTag())).hasEndTag((TagToken)lastSibling.getMaster()) ? lastSibling.getMaster().isRightTrim() : lastSibling.getMaster().isRightTrimAfterEnd();
        }
        return lastSibling.getMaster().isRightTrim();
    }

    private Node expression(ExpressionToken expressionToken) {
        ExpressionNode n = this.createExpressionNode(expressionToken);
        n.setParent(this.parent);
        return n;
    }

    private ExpressionNode createExpressionNode(ExpressionToken expressionToken) {
        return new ExpressionNode(this.interpreter.getContext().getExpressionStrategy(), expressionToken);
    }

    private Node tag(TagToken tagToken) {
        Tag tag;
        try {
            tag = this.interpreter.getContext().getTag(tagToken.getTagName());
            if (tag == null) {
                this.interpreter.addError(TemplateError.fromException(new UnknownTagException(tagToken)));
                return null;
            }
        }
        catch (DisabledException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, TemplateError.ErrorItem.TAG, e.getMessage(), tagToken.getTagName(), this.interpreter.getLineNumber(), tagToken.getStartPosition(), e));
            return null;
        }
        if (tag instanceof EndTag) {
            this.endTag(tag, tagToken);
            return null;
        }
        TagNode node = new TagNode(tag, tagToken, this.symbols);
        node.setParent(this.parent);
        if (node.getEndName() != null && (!(tag instanceof FlexibleTag) || ((FlexibleTag)((Object)tag)).hasEndTag(tagToken))) {
            this.parent.getChildren().add(node);
            this.parent = node;
            return null;
        }
        return node;
    }

    private void endTag(Tag tag, TagToken tagToken) {
        if (this.parent.getMaster() != null) {
            this.parent.getMaster().setRightTrimAfterEnd(tagToken.isRightTrim());
        }
        boolean hasMatchingStartTag = false;
        while (!(this.parent instanceof RootNode)) {
            TagNode parentTag = (TagNode)this.parent;
            this.parent = this.parent.getParent();
            if (parentTag.getEndName().equals(tag.getEndTagName())) {
                hasMatchingStartTag = true;
                break;
            }
            this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(tagToken.getImage(), "Mismatched end tag, expected: " + parentTag.getEndName(), tagToken.getLineNumber(), tagToken.getStartPosition())));
        }
        if (!hasMatchingStartTag) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Missing start tag", tag.getName(), tagToken.getLineNumber(), tagToken.getStartPosition(), null));
        }
    }

    private boolean isTrimmingEnabledForToken(Token token, JinjavaConfig jinjavaConfig) {
        if (token instanceof TagToken || token instanceof TextToken) {
            return true;
        }
        return jinjavaConfig.getLegacyOverrides().isUseTrimmingForNotesAndExpressions();
    }
}

