/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.expression.ExpressionStrategy;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.tree.parse.ExpressionToken;

public class ExpressionNode
extends Node {
    private final ExpressionStrategy expressionStrategy;
    private final ExpressionToken master;

    public ExpressionNode(ExpressionStrategy expressionStrategy, ExpressionToken token) {
        super(token, token.getLineNumber(), token.getStartPosition());
        this.expressionStrategy = expressionStrategy;
        this.master = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputNode render(JinjavaInterpreter interpreter) {
        this.preProcess(interpreter);
        try {
            RenderedOutputNode renderedOutputNode = this.expressionStrategy.interpretOutput(this.master, interpreter);
            return renderedOutputNode;
        }
        catch (DeferredValueException e) {
            interpreter.getContext().handleDeferredNode(this);
            RenderedOutputNode renderedOutputNode = new RenderedOutputNode(this.master.getImage());
            return renderedOutputNode;
        }
        finally {
            this.postProcess(interpreter);
        }
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

