/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.hubspot.jinjava.objects.serialization.LengthLimitingWriter;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class MapEntrySerializer
extends JsonSerializer<Map.Entry<?, ?>> {
    public static final MapEntrySerializer INSTANCE = new MapEntrySerializer();

    private MapEntrySerializer() {
    }

    @Override
    public void serialize(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String value;
        String key;
        AtomicInteger remainingLength = (AtomicInteger)serializerProvider.getAttribute("remainingLength");
        ObjectWriter objectWriter = PyishObjectMapper.PYISH_OBJECT_WRITER.withAttribute("allowSnakeCase", serializerProvider.getAttribute("allowSnakeCase"));
        if (remainingLength != null) {
            objectWriter = objectWriter.withAttribute("remainingLength", remainingLength);
            key = objectWriter.writeValueAsString(entry.getKey());
            LengthLimitingWriter lengthLimitingWriter = new LengthLimitingWriter(new CharArrayWriter(), remainingLength);
            objectWriter.writeValue(lengthLimitingWriter, entry.getValue());
            value = lengthLimitingWriter.toString();
        } else {
            key = objectWriter.writeValueAsString(entry.getKey());
            value = objectWriter.writeValueAsString(entry.getValue());
        }
        jsonGenerator.writeRawValue(String.format("fn:map_entry(%s, %s)", key, value));
    }
}

