/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.collections;

import com.hubspot.jinjava.interpret.CollectionTooBigException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.objects.collections.PyMap;
import java.util.HashSet;
import java.util.Map;

public class SizeLimitingPyMap
extends PyMap {
    private int maxSize;
    private boolean hasWarned;

    public SizeLimitingPyMap(Map<String, Object> map, int maxSize) {
        super(map);
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be >= 1");
        }
        this.maxSize = maxSize;
        this.checkSize(map.size());
    }

    @Override
    public Object put(String s, Object o) {
        if (!this.delegate().containsKey(s)) {
            this.checkSize(this.delegate().size() + 1);
        }
        return super.put(s, o);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        HashSet keys = new HashSet(this.delegate().keySet());
        this.checkSize((int)m.keySet().stream().filter(k -> !keys.contains(k)).count() + this.delegate().size());
        super.putAll((Map<? extends String, ? extends Object>)m);
    }

    private void checkSize(int newSize) {
        if (newSize > this.maxSize) {
            throw new CollectionTooBigException(newSize, this.maxSize);
        }
        if (!this.hasWarned && (double)newSize >= (double)this.maxSize * 0.9) {
            this.hasWarned = true;
            JinjavaInterpreter.getCurrent().addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.COLLECTION_TOO_BIG, String.format("Map is at 90%% of max size (%d of %d)", newSize, this.maxSize), null, -1, -1, new CollectionTooBigException(newSize, this.maxSize)));
        }
    }
}

