/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.collections;

import com.google.common.collect.ForwardingMap;
import com.hubspot.jinjava.objects.PyWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PyMap
extends ForwardingMap<String, Object>
implements PyWrapper {
    private boolean computingHashCode = false;
    private final Map<String, Object> map;

    public PyMap(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    protected Map<String, Object> delegate() {
        return this.map;
    }

    @Override
    public Object put(String s, Object o) {
        if (o == this) {
            throw new IllegalArgumentException("Can't add map object to itself");
        }
        return this.delegate().put(s, o);
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    public Map<String, Object> toMap() {
        return this.map;
    }

    public Set<Map.Entry<String, Object>> items() {
        return this.entrySet();
    }

    public Set<String> keys() {
        return this.keySet();
    }

    public void update(Map<? extends String, ? extends Object> m) {
        if (m == this) {
            throw new IllegalArgumentException("Can't update map object with itself");
        }
        this.putAll(m);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m == this) {
            throw new IllegalArgumentException("Map putAll() operation can't be used to add map to itself");
        }
        super.putAll(m);
    }

    @Override
    public int hashCode() {
        if (this.computingHashCode) {
            return Objects.hashCode(null);
        }
        try {
            this.computingHashCode = true;
            int n = super.hashCode();
            return n;
        }
        finally {
            this.computingHashCode = false;
        }
    }
}

