/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.tag.ImportTag;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategyFactory;
import com.hubspot.jinjava.lib.tag.eager.importing.ImportingData;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class EagerImportTag
extends EagerStateChangingTag<ImportTag> {
    public EagerImportTag() {
        super(new ImportTag());
    }

    public EagerImportTag(ImportTag importTag) {
        super(importTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        Optional<String> maybeTemplateFile;
        ImportingData importingData = EagerImportingStrategyFactory.getImportingData(tagToken, interpreter);
        EagerImportingStrategy eagerImportingStrategy = EagerImportingStrategyFactory.create(importingData);
        try {
            maybeTemplateFile = ImportTag.getTemplateFile(importingData.getHelpers(), tagToken, interpreter);
        }
        catch (DeferredValueException e) {
            return eagerImportingStrategy.handleDeferredTemplateFile(e);
        }
        if (!maybeTemplateFile.isPresent()) {
            return "";
        }
        String templateFile = maybeTemplateFile.get();
        try {
            String output;
            Node node = ImportTag.parseTemplateAsNode(interpreter, templateFile);
            String newPathSetter = EagerImportingStrategyFactory.getSetTagForCurrentPath(interpreter);
            JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
            child.getContext().put("import_resource_path", templateFile);
            JinjavaInterpreter.pushCurrent(child);
            try {
                eagerImportingStrategy.setup(child);
                output = child.render(node);
            }
            finally {
                JinjavaInterpreter.popCurrent();
            }
            interpreter.addAllChildErrors(templateFile, child.getErrorsCopy());
            Map<String, Object> childBindings = child.getContext().getSessionBindings();
            if (!child.getContext().getDeferredNodes().isEmpty() || interpreter.getContext().isDeferredExecutionMode() && !child.getContext().getGlobalMacros().isEmpty()) {
                ImportTag.handleDeferredNodesDuringImport(node, ImportTag.getContextVar(importingData.getHelpers()), childBindings, child, interpreter);
                throw new DeferredValueException(templateFile, tagToken.getLineNumber(), tagToken.getStartPosition());
            }
            eagerImportingStrategy.integrateChild(child);
            if (child.getContext().getDeferredTokens().isEmpty() || output == null) {
                String string = "";
                return string;
            }
            String string = EagerReconstructionUtils.wrapInTag(eagerImportingStrategy.getFinalOutput(newPathSetter, output, child), "do", interpreter, true);
            return string;
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        finally {
            interpreter.getContext().getCurrentPathStack().pop();
            interpreter.getContext().getImportPathStack().pop();
        }
    }
}

