/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.IfTag;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerTagDecorator;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class EagerIfTag
extends EagerTagDecorator<IfTag> {
    public EagerIfTag() {
        super(new IfTag());
    }

    public EagerIfTag(IfTag ifTag) {
        super(ifTag);
    }

    @Override
    public String innerInterpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        return ((IfTag)this.getTag()).interpret(tagNode, interpreter);
    }

    @Override
    public String eagerInterpret(TagNode tagNode, JinjavaInterpreter interpreter, InterpretException e) {
        if (StringUtils.isBlank(tagNode.getHelpers())) {
            throw new TemplateSyntaxException(interpreter, tagNode.getMaster().getImage(), "Tag 'if' expects expression");
        }
        LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        result.append(EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(this.eagerRenderBranches(tagNode, (JinjavaInterpreter)eagerInterpreter, e)), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build()).asTemplateString());
        tagNode.getMaster().setRightTrimAfterEnd(false);
        result.append(EagerReconstructionUtils.reconstructEnd(tagNode));
        return result.toString();
    }

    public String eagerRenderBranches(TagNode tagNode, JinjavaInterpreter interpreter, InterpretException e) {
        int deferredLineNumber = interpreter.getLineNumber();
        int deferredPosition = interpreter.getPosition();
        boolean definitelyDrop = this.shouldDropBranch(tagNode, interpreter, deferredLineNumber, deferredPosition);
        boolean definitelyExecuted = false;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEagerImage(this.buildToken(tagNode, e, deferredLineNumber, deferredPosition), interpreter));
        int branchStart = 0;
        int childrenSize = tagNode.getChildren().size();
        HashSet<String> bindingsToDefer = new HashSet<String>();
        while (branchStart < childrenSize) {
            int branchEnd = this.findNextElseToken(tagNode, branchStart);
            if (!definitelyDrop) {
                int finalBranchStart = branchStart;
                EagerExecutionResult result = EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(this.evaluateBranch(tagNode, finalBranchStart, branchEnd, interpreter)), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build());
                sb.append(result.getResult());
                bindingsToDefer.addAll(EagerReconstructionUtils.resetSpeculativeBindings(interpreter, result));
            }
            if (branchEnd >= childrenSize || definitelyExecuted) break;
            TagNode caseNode = (TagNode)tagNode.getChildren().get(branchEnd);
            boolean bl = definitelyDrop = caseNode.getName().equals("elif") && this.shouldDropBranch(caseNode, interpreter, deferredLineNumber, deferredPosition);
            if (!definitelyDrop) {
                boolean bl2 = definitelyExecuted = caseNode.getName().equals("else") || this.isDefinitelyExecuted(caseNode, interpreter, deferredLineNumber);
                if (definitelyExecuted) {
                    sb.append(String.format("%s else %s", caseNode.getSymbols().getExpressionStartWithTag(), caseNode.getSymbols().getExpressionEndWithTag()));
                } else {
                    sb.append(this.getEagerImage(this.buildToken(caseNode, e, deferredLineNumber, deferredPosition), interpreter));
                }
            }
            branchStart = branchEnd + 1;
        }
        PrefixToPreserveState prefixToPreserveState = EagerReconstructionUtils.deferWordsAndReconstructReferences(interpreter, bindingsToDefer);
        return prefixToPreserveState + sb.toString();
    }

    private String evaluateBranch(TagNode tagNode, int startIdx, int endIdx, JinjavaInterpreter interpreter) {
        StringBuilder sb = new StringBuilder();
        for (int i = startIdx; i < endIdx; ++i) {
            Node child = tagNode.getChildren().get(i);
            sb.append(child.render(interpreter).getValue());
        }
        return sb.toString();
    }

    private int findNextElseToken(TagNode tagNode, int startIdx) {
        int i;
        for (i = startIdx; i < tagNode.getChildren().size(); ++i) {
            Node childNode = tagNode.getChildren().get(i);
            if ((!TagNode.class.isAssignableFrom(childNode.getClass()) || !childNode.getName().equals("elif")) && !childNode.getName().equals("else")) continue;
            return i;
        }
        return i;
    }

    private boolean shouldDropBranch(TagNode tagNode, JinjavaInterpreter eagerInterpreter, int deferredLineNumber, int deferredPosition) {
        if (deferredLineNumber > tagNode.getLineNumber()) {
            return true;
        }
        if (deferredLineNumber == tagNode.getLineNumber() && deferredPosition >= tagNode.getStartPosition()) {
            return deferredPosition > tagNode.getStartPosition();
        }
        try {
            return !((IfTag)this.getTag()).isPositiveIfElseNode(tagNode, eagerInterpreter);
        }
        catch (DeferredValueException e) {
            return false;
        }
    }

    private boolean isDefinitelyExecuted(TagNode tagNode, JinjavaInterpreter eagerInterpreter, int deferredLineNumber) {
        if (deferredLineNumber == tagNode.getLineNumber()) {
            return false;
        }
        try {
            return ((IfTag)this.getTag()).isPositiveIfElseNode(tagNode, eagerInterpreter);
        }
        catch (DeferredValueException e) {
            return false;
        }
    }
}

