/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="macro_name"), @JinjavaParam(value="argument_names")})
public class MacroTag
implements Tag {
    public static final String TAG_NAME = "macro";
    private static final long serialVersionUID = 8397609322126956077L;
    public static final Pattern CHILD_MACRO_PATTERN = Pattern.compile("([a-zA-Z_][\\w_]*)\\.([a-zA-Z_][\\w_]*)[^(]*\\(([^)]*)\\)");
    public static final Pattern MACRO_PATTERN = Pattern.compile("([a-zA-Z_][\\w_]*)[^(]*\\(([^)]*)\\)");
    private static final Splitter ARGS_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        parentName = "";
        childMatcher = MacroTag.CHILD_MACRO_PATTERN.matcher(tagNode.getHelpers());
        if (childMatcher.find()) {
            parentName = childMatcher.group(1);
            name = childMatcher.group(2);
            args = Strings.nullToEmpty(childMatcher.group(3));
        } else {
            matcher = MacroTag.MACRO_PATTERN.matcher(tagNode.getHelpers());
            if (!matcher.find()) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Unable to parse macro definition: " + tagNode.getHelpers(), tagNode.getLineNumber(), tagNode.getStartPosition());
            }
            name = matcher.group(1);
            args = Strings.nullToEmpty(matcher.group(2));
        }
        argNamesWithDefaults = new LinkedHashMap<String, Object>();
        deferred = MacroTag.populateArgNames(tagNode.getLineNumber(), interpreter, args, argNamesWithDefaults);
        contextImportResourcePath /* !! */  = interpreter.getContext().get("deferred_import_resource_path");
        if (contextImportResourcePath /* !! */  instanceof DeferredValue) {
            contextImportResourcePath /* !! */  = ((DeferredValue)contextImportResourcePath /* !! */ ).getOriginalValue();
        }
        scopeEntered = false;
        try {
            if (StringUtils.isNotEmpty((String)contextImportResourcePath /* !! */ )) {
                scopeEntered = true;
                interpreter.enterScope();
                interpreter.getContext().put("import_resource_path", contextImportResourcePath /* !! */ );
            }
            macro = this.constructMacroFunction(tagNode, interpreter, name, argNamesWithDefaults);
        }
        finally {
            if (scopeEntered) {
                interpreter.leaveScope();
            }
        }
        macro.setDeferred(deferred);
        if (StringUtils.isNotEmpty(parentName)) {
            try {
                if (!(interpreter.getContext().get(parentName) instanceof DeferredValue)) {
                    macroOfParent = interpreter.getContext().getOrDefault(parentName, new HashMap<K, V>());
                    macroOfParent.put(macro.getName(), macro);
                    if (interpreter.getContext().containsKey(parentName)) ** GOTO lbl58
                    interpreter.getContext().put(parentName, macroOfParent);
                }
                originalValue = ((DeferredValue)interpreter.getContext().get(parentName)).getOriginalValue();
                if (originalValue instanceof Map) {
                    ((Map)originalValue).put(macro.getName(), macro);
                }
                macroOfParent = new HashMap<String, MacroFunction>();
                macroOfParent.put(macro.getName(), macro);
                interpreter.getContext().put(parentName, DeferredValue.instance(macroOfParent));
            }
            catch (ClassCastException e) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Unable to parse macro as a child of: " + parentName, tagNode.getLineNumber(), tagNode.getStartPosition());
            }
        } else {
            interpreter.getContext().addGlobalMacro(macro);
        }
lbl58:
        // 5 sources

        if (deferred) {
            throw new DeferredValueException(name, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        return "";
    }

    protected MacroFunction constructMacroFunction(TagNode tagNode, JinjavaInterpreter interpreter, String name, LinkedHashMap<String, Object> argNamesWithDefaults) {
        return new MacroFunction(tagNode.getChildren(), name, argNamesWithDefaults, false, interpreter.getContext(), interpreter.getLineNumber(), interpreter.getPosition());
    }

    public static boolean populateArgNames(int lineNumber, JinjavaInterpreter interpreter, String args, LinkedHashMap<String, Object> argNamesWithDefaults) {
        ArrayList<String> argList = Lists.newArrayList(ARGS_SPLITTER.split(args));
        boolean deferred = false;
        for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            if (arg.contains("=")) {
                String argName = StringUtils.substringBefore(arg, "=").trim();
                StringBuilder argValStr = new StringBuilder(StringUtils.substringAfter(arg, "=").trim());
                if (StringUtils.startsWith(argValStr, "[") && !StringUtils.endsWith(argValStr, "]")) {
                    while (i + 1 < argList.size() && !StringUtils.endsWith(argValStr, "]")) {
                        argValStr.append(", ").append((String)argList.get(i + 1));
                        ++i;
                    }
                }
                try {
                    Object argVal = interpreter.resolveELExpression(argValStr.toString(), lineNumber);
                    argNamesWithDefaults.put(argName, argVal);
                }
                catch (DeferredValueException e) {
                    deferred = true;
                }
                continue;
            }
            argNamesWithDefaults.put(arg, null);
        }
        return deferred;
    }
}

