/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.IncludeTagCycleException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="path")})
public class IncludeTag
implements Tag {
    public static final String TAG_NAME = "include";
    private static final long serialVersionUID = -8391753639874726854L;

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        HelperStringTokenizer helper = new HelperStringTokenizer(tagNode.getHelpers());
        if (!helper.hasNext()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'include' expects template path", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String path = StringUtils.trimToEmpty((String)helper.next());
        String templateFile = interpreter.resolveString(path, tagNode.getLineNumber(), tagNode.getStartPosition());
        templateFile = interpreter.resolveResourceLocation(templateFile);
        try {
            interpreter.getContext().getIncludePathStack().push(templateFile, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        catch (IncludeTagCycleException e) {
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Include cycle detected for path: '" + templateFile + "'", null, tagNode.getLineNumber(), tagNode.getStartPosition(), e, BasicTemplateErrorCategory.INCLUDE_CYCLE_DETECTED, ImmutableMap.of("path", templateFile)));
            return "";
        }
        try {
            String template = interpreter.getResource(templateFile);
            Node node = interpreter.parse(template);
            interpreter.getContext().addDependency("coded_files", templateFile);
            interpreter.getContext().getCurrentPathStack().push(templateFile, interpreter.getLineNumber(), interpreter.getPosition());
            String string = interpreter.render(node, false);
            return string;
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        finally {
            interpreter.getContext().getIncludePathStack().pop();
            interpreter.getContext().getCurrentPathStack().pop();
        }
    }

    @Override
    public String getEndTagName() {
        return null;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

