/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn;

import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MacroFunction
extends AbstractCallableMethod {
    public static final String KWARGS_KEY = "kwargs";
    public static final String VARARGS_KEY = "varargs";
    protected final List<Node> content;
    protected final boolean caller;
    protected final Context localContextScope;
    protected final int definitionLineNumber;
    protected final int definitionStartPosition;
    protected boolean deferred;

    public MacroFunction(List<Node> content, String name, LinkedHashMap<String, Object> argNamesWithDefaults, boolean caller, Context localContextScope, int lineNumber, int startPosition) {
        super(name, argNamesWithDefaults);
        this.content = content;
        this.caller = caller;
        this.localContextScope = localContextScope;
        this.definitionLineNumber = lineNumber;
        this.definitionStartPosition = startPosition;
        this.deferred = false;
    }

    public MacroFunction(MacroFunction source, String name) {
        super(name, (LinkedHashMap)source.getDefaults());
        this.content = source.content;
        this.caller = source.caller;
        this.localContextScope = source.localContextScope;
        this.definitionLineNumber = source.definitionLineNumber;
        this.definitionStartPosition = source.definitionStartPosition;
        this.deferred = source.deferred;
    }

    @Override
    public Object doEvaluate(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs) {
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        Optional<String> importFile = this.getImportFile(interpreter);
        try {
            JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();
            try {
                String string = this.getEvaluationResult(argMap, kwargMap, varArgs, interpreter);
                if (c != null) {
                    c.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            importFile.ifPresent(path -> interpreter.getContext().getCurrentPathStack().pop());
        }
    }

    public Optional<String> getImportFile(JinjavaInterpreter interpreter) {
        Optional<String> importFile = Optional.ofNullable((String)this.localContextScope.get("import_resource_path"));
        importFile.ifPresent(path -> interpreter.getContext().getCurrentPathStack().pushWithoutCycleCheck((String)path, interpreter.getLineNumber(), interpreter.getPosition()));
        return importFile;
    }

    public String getEvaluationResult(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs, JinjavaInterpreter interpreter) {
        interpreter.setLineNumber(this.definitionLineNumber);
        interpreter.setPosition(this.definitionStartPosition);
        if (!Objects.equals(interpreter.getContext().get("import_resource_path"), this.localContextScope.get("import_resource_path"))) {
            for (Map.Entry<String, Object> entry : this.localContextScope.getScope().entrySet()) {
                if (entry.getValue() instanceof MacroFunction) {
                    interpreter.getContext().addGlobalMacro((MacroFunction)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("__macros__")) {
                    interpreter.getContext().put("__macros__", new HashMap((Map)entry.getValue()));
                    continue;
                }
                if (this.alreadyDeferredInEarlierCall(entry.getKey(), interpreter)) continue;
                interpreter.getContext().put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : argMap.entrySet()) {
            interpreter.getContext().put(entry.getKey(), entry.getValue());
        }
        interpreter.getContext().put(KWARGS_KEY, kwargMap);
        interpreter.getContext().put(VARARGS_KEY, varArgs);
        LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        try (Context.TemporaryValueClosable<Boolean> temporaryValueClosable = interpreter.getContext().withUnwrapRawOverride();){
            for (Node node : this.content) {
                result.append(node.render(interpreter));
            }
        }
        return result.toString();
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public String reconstructImage() {
        if (this.content != null && !this.content.isEmpty()) {
            return this.content.get(0).getParent().reconstructImage();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroFunction that = (MacroFunction)o;
        return this.caller == that.caller && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.localContextScope.get("import_resource_path"), that.localContextScope.get("import_resource_path"));
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.localContextScope.get("import_resource_path"), this.caller);
    }

    private boolean alreadyDeferredInEarlierCall(String key, JinjavaInterpreter interpreter) {
        if (interpreter.getContext().get(key) instanceof DeferredValue) {
            Context penultimateParent = interpreter.getContext().getPenultimateParent();
            String importResourcePath = (String)this.localContextScope.get("import_resource_path");
            return penultimateParent.getDeferredTokens().stream().filter(deferredToken -> Objects.equals(importResourcePath, deferredToken.getImportResourcePath())).anyMatch(deferredToken -> deferredToken.getSetDeferredWords().contains(key) || deferredToken.getUsedDeferredWords().stream().anyMatch(used -> key.equals(used.split("\\.", 2)[0])));
        }
        return false;
    }
}

