/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="separator", defaultValue=" "), @JinjavaParam(value="limit", type="number", defaultValue="0")})
public class SplitFilter
implements Filter {
    @Override
    public String getName() {
        return "split";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        int limit;
        Splitter splitter = args != null && args.length > 0 ? (args[0] != null ? Splitter.on(args[0]) : Splitter.on(CharMatcher.whitespace())) : Splitter.on(CharMatcher.whitespace());
        if (args != null && args.length > 1 && (limit = NumberUtils.toInt(args[1], 0)) > 0) {
            splitter = splitter.limit(limit);
        }
        return Lists.newArrayList(splitter.omitEmptyStrings().trimResults().split(Objects.toString(var, "")));
    }
}

