/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="old", required=true), @JinjavaParam(value="new", required=true), @JinjavaParam(value="count", type="number")})
public class ReplaceFilter
implements Filter {
    @Override
    public String getName() {
        return "replace";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null) {
            return null;
        }
        if (args.length < 2) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 2 arguments (substring to replace, replacement string) or 3 arguments (substring to replace, replacement string, number of occurrences to replace)");
        }
        String s = var.toString();
        if (s.length() > 100) {
            ReplaceFilter.checkLength(interpreter, s, this);
        }
        String toReplace = args[0];
        String replaceWith = args[1];
        Integer count = null;
        if (args.length > 2) {
            count = NumberUtils.createInteger(args[2]);
        }
        if (count == null) {
            return StringUtils.replace(s, toReplace, replaceWith);
        }
        return StringUtils.replace(s, toReplace, replaceWith, count);
    }

    static void checkLength(JinjavaInterpreter interpreter, String s, Importable importable) {
        long maxStringLength = interpreter.getConfig().getMaxStringLength();
        if (maxStringLength > 0L && (long)s.length() > maxStringLength) {
            throw new InvalidInputException(interpreter, importable, InvalidReason.LENGTH, s.length(), maxStringLength);
        }
    }
}

