/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.el.TruthyTypeConverter;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.AdvancedFilter;
import java.math.BigDecimal;
import java.util.Map;
import jinjava.de.odysseus.el.misc.NumberOperations;

@JinjavaDoc(params={@JinjavaParam(value="divisor", type="number", required=true)})
public class DivideFilter
implements AdvancedFilter {
    private static final TruthyTypeConverter TYPE_CONVERTER = new TruthyTypeConverter();

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, Object[] args, Map<String, Object> kwargs) {
        Number num;
        if (args.length < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 number (divisor) argument");
        }
        Object toMul = args[0];
        if (toMul != null) {
            if (interpreter.getConfig().getEnablePreciseDivideFilter() && toMul instanceof Number) {
                num = (Number)toMul;
            } else {
                try {
                    num = new BigDecimal(toMul.toString());
                }
                catch (NumberFormatException e) {
                    throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.NUMBER_FORMAT, 0, toMul);
                }
            }
        } else {
            return var;
        }
        return NumberOperations.div(TYPE_CONVERTER, var, num);
    }

    @Override
    public String getName() {
        return "divide";
    }
}

