/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="linecount", type="number", defaultValue="0"), @JinjavaParam(value="fill_with")})
public class BatchFilter
implements Filter {
    @Override
    public String getName() {
        return "batch";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null || args.length == 0) {
            return Collections.emptyList();
        }
        int lineCount = NumberUtils.toInt(args[0], 0);
        if (lineCount == 0) {
            return Collections.emptyList();
        }
        String fillWith = args.length > 1 ? args[1] : null;
        ForLoop loop = ObjectIterator.getLoop(var);
        ArrayList result = new ArrayList();
        ArrayList<Object> currentRow = null;
        while (loop.hasNext()) {
            Object item = loop.next();
            if (currentRow == null) {
                currentRow = new ArrayList<Object>();
                result.add(currentRow);
            }
            currentRow.add(item);
            if (currentRow.size() != lineCount) continue;
            currentRow = null;
        }
        if (currentRow != null) {
            while (currentRow.size() < lineCount) {
                currentRow.add(fillWith);
            }
        }
        return result;
    }
}

