/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;

@JinjavaDoc(params={@JinjavaParam(value="addend", type="number", required=true)})
public class AddFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... args) {
        BigDecimal addend;
        BigDecimal base;
        if (object == null) {
            return null;
        }
        if (args.length < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 argument (number to add to base)");
        }
        try {
            base = new BigDecimal(object.toString());
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException(interpreter, this, InvalidReason.NUMBER_FORMAT, object.toString());
        }
        if (args[0] == null) {
            return base;
        }
        try {
            addend = new BigDecimal(args[0]);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.NUMBER_FORMAT, 0, args[0]);
        }
        return base.add(addend);
    }

    @Override
    public String getName() {
        return "add";
    }
}

