/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.Node;
import java.util.function.BiConsumer;

public class JinjavaProcessors {
    private final BiConsumer<Node, JinjavaInterpreter> nodePreProcessor;
    private final BiConsumer<Node, JinjavaInterpreter> nodePostProcessor;

    private JinjavaProcessors(Builder builder) {
        this.nodePreProcessor = builder.nodePreProcessor;
        this.nodePostProcessor = builder.nodePostProcessor;
    }

    public BiConsumer<Node, JinjavaInterpreter> getNodePreProcessor() {
        return this.nodePreProcessor;
    }

    public BiConsumer<Node, JinjavaInterpreter> getNodePostProcessor() {
        return this.nodePostProcessor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(JinjavaProcessors processors) {
        return new Builder(processors);
    }

    public static class Builder {
        private BiConsumer<Node, JinjavaInterpreter> nodePreProcessor;
        private BiConsumer<Node, JinjavaInterpreter> nodePostProcessor;

        private Builder() {
            this.nodePreProcessor = (n, i) -> {};
            this.nodePostProcessor = (n, i) -> {};
        }

        private Builder(JinjavaProcessors processors) {
            this.nodePreProcessor = (n, i) -> {};
            this.nodePostProcessor = (n, i) -> {};
            this.nodePreProcessor = processors.nodePreProcessor;
            this.nodePostProcessor = processors.nodePostProcessor;
        }

        public Builder withNodePreProcessor(BiConsumer<Node, JinjavaInterpreter> processor) {
            this.nodePreProcessor = processor;
            return this;
        }

        public Builder withNodePostProcessor(BiConsumer<Node, JinjavaInterpreter> processor) {
            this.nodePostProcessor = processor;
            return this;
        }

        public JinjavaProcessors build() {
            return new JinjavaProcessors(this);
        }
    }
}

