/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IPv6AddressRange
implements Serializable,
Comparable<IPv6AddressRange>,
Iterable<IPv6Address> {
    private final IPv6Address first;
    private final IPv6Address last;

    IPv6AddressRange(IPv6Address first, IPv6Address last) {
        if (first.compareTo(last) > 0) {
            throw new IllegalArgumentException("Cannot create ip address range with last address < first address");
        }
        this.first = first;
        this.last = last;
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return new IPv6AddressRangeIterator();
    }

    public String toString() {
        return this.first.toString() + " - " + this.last.toString();
    }

    @Override
    public int compareTo(IPv6AddressRange that) {
        if (!this.first.equals(that.first)) {
            return this.first.compareTo(that.first);
        }
        return this.last.compareTo(that.last);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPv6AddressRange)) {
            return false;
        }
        IPv6AddressRange that = (IPv6AddressRange)o;
        if (this.first != null ? !this.first.equals(that.first) : that.first != null) {
            return false;
        }
        return !(this.last != null ? !this.last.equals(that.last) : that.last != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.last != null ? this.last.hashCode() : 0);
        return result;
    }

    public IPv6Address getFirst() {
        return this.first;
    }

    public IPv6Address getLast() {
        return this.last;
    }

    private final class IPv6AddressRangeIterator
    implements Iterator<IPv6Address> {
        private IPv6Address current;

        private IPv6AddressRangeIterator() {
            this.current = IPv6AddressRange.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(IPv6AddressRange.this.last) <= 0;
        }

        @Override
        public IPv6Address next() {
            if (this.hasNext()) {
                IPv6Address result = this.current;
                this.current = this.current.add(1);
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator provides read only access");
        }
    }
}

