/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public static Joiner on(char separator) {
        return new Joiner(String.valueOf(separator));
    }

    private Joiner(String separator) {
        this.separator = Preconditions.checkNotNull(separator);
    }

    public <A extends Appendable> A appendTo(A appendable, Iterator<? extends @Nullable Object> parts) throws IOException {
        Preconditions.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    public final StringBuilder appendTo(StringBuilder builder, Iterable<? extends @Nullable Object> parts) {
        return this.appendTo(builder, parts.iterator());
    }

    public final StringBuilder appendTo(StringBuilder builder, Iterator<? extends @Nullable Object> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public final String join(Iterable<? extends @Nullable Object> parts) {
        return this.join(parts.iterator());
    }

    public final String join(Iterator<? extends @Nullable Object> parts) {
        return this.appendTo(new StringBuilder(), parts).toString();
    }

    public final String join(Object first, Object second, Object ... rest) {
        return this.join(Joiner.iterable(first, second, rest));
    }

    CharSequence toString(Object part) {
        Objects.requireNonNull(part);
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }

    private static Iterable<@Nullable Object> iterable(final Object first, final Object second, final @Nullable Object[] rest) {
        Preconditions.checkNotNull(rest);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return rest.length + 2;
            }

            @Override
            public Object get(int index) {
                switch (index) {
                    case 0: {
                        return first;
                    }
                    case 1: {
                        return second;
                    }
                }
                return rest[index - 2];
            }
        };
    }
}

