/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.util.NamingStrategyImpls;
import java.io.Serializable;

public abstract class PropertyNamingStrategies
implements Serializable {
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = LowerCamelCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = UpperCamelCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy SNAKE_CASE = SnakeCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy UPPER_SNAKE_CASE = UpperSnakeCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy LOWER_CASE = LowerCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy KEBAB_CASE = KebabCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy LOWER_DOT_CASE = LowerDotCaseStrategy.INSTANCE;

    public static class LowerDotCaseStrategy
    extends NamingBase {
        public static final LowerDotCaseStrategy INSTANCE = new LowerDotCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.LOWER_DOT_CASE.translate(input);
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        public static final KebabCaseStrategy INSTANCE = new KebabCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.KEBAB_CASE.translate(input);
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        public static final LowerCaseStrategy INSTANCE = new LowerCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.LOWER_CASE.translate(input);
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        public static final UpperCamelCaseStrategy INSTANCE = new UpperCamelCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.UPPER_CAMEL_CASE.translate(input);
        }
    }

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        public static final LowerCamelCaseStrategy INSTANCE = new LowerCamelCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.LOWER_CAMEL_CASE.translate(input);
        }
    }

    public static class UpperSnakeCaseStrategy
    extends SnakeCaseStrategy {
        public static final UpperSnakeCaseStrategy INSTANCE = new UpperSnakeCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.UPPER_SNAKE_CASE.translate(input);
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        public static final SnakeCaseStrategy INSTANCE = new SnakeCaseStrategy();

        @Override
        public String translate(String input) {
            return NamingStrategyImpls.SNAKE_CASE.translate(input);
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.translate(defaultName);
        }

        public abstract String translate(String var1);
    }
}

