/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.internal.ExpCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalMath {
    private static final BigDecimal TWO;
    private static final BigDecimal THREE;
    private static final BigDecimal MINUS_ONE;
    private static final BigDecimal DOUBLE_MAX_VALUE;
    private static final Object log2CacheLock;
    private static final Object log3CacheLock;
    private static volatile BigDecimal log10Cache;
    private static final Object log10CacheLock;
    private static final Object piCacheLock;
    private static final Object eCacheLock;
    private static final BigDecimal ROUGHLY_TWO_PI;
    private static BigDecimal[] factorialCache;

    public static boolean isDoubleValue(BigDecimal value) {
        if (value.compareTo(DOUBLE_MAX_VALUE) > 0) {
            return false;
        }
        return value.compareTo(DOUBLE_MAX_VALUE.negate()) >= 0;
    }

    public static BigDecimal mantissa(BigDecimal value) {
        int exponent = BigDecimalMath.exponent(value);
        if (exponent == 0) {
            return value;
        }
        return value.movePointLeft(exponent);
    }

    public static int exponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static BigDecimal integralPart(BigDecimal value) {
        return value.setScale(0, 1);
    }

    public static BigDecimal fractionalPart(BigDecimal value) {
        return value.subtract(BigDecimalMath.integralPart(value));
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        if (x.signum() == 0) {
            switch (y.signum()) {
                case 0: {
                    return BigDecimal.ONE;
                }
                case 1: {
                    return BigDecimal.ZERO;
                }
            }
        }
        try {
            long longValue = y.longValueExact();
            return BigDecimalMath.pow(x, longValue, mathContext);
        }
        catch (ArithmeticException longValue) {
            if (BigDecimalMath.fractionalPart(y).signum() == 0) {
                return BigDecimalMath.powInteger(x, y, mathContext);
            }
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal result = BigDecimalMath.exp(y.multiply(BigDecimalMath.log(x, mc), mc), mc);
            return result.round(mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal x, long y, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        if (y < 0L) {
            return BigDecimal.ONE.divide(BigDecimalMath.pow(x, -y, mc), mc).round(mathContext);
        }
        BigDecimal result = BigDecimal.ONE;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0L) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return result.round(mathContext);
    }

    private static BigDecimal powInteger(BigDecimal x, BigDecimal integerY, MathContext mathContext) {
        if (BigDecimalMath.fractionalPart(integerY).signum() != 0) {
            throw new IllegalArgumentException("Not integer value: " + integerY);
        }
        if (integerY.signum() < 0) {
            return BigDecimal.ONE.divide(BigDecimalMath.powInteger(x, integerY.negate(), mathContext), mathContext);
        }
        MathContext mc = new MathContext(Math.max(mathContext.getPrecision(), -integerY.scale()) + 30, mathContext.getRoundingMode());
        BigDecimal result = BigDecimal.ONE;
        while (integerY.signum() > 0) {
            BigDecimal halfY = integerY.divide(TWO, mc);
            if (BigDecimalMath.fractionalPart(halfY).signum() != 0) {
                result = result.multiply(x, mc);
                integerY = integerY.subtract(BigDecimal.ONE);
                halfY = integerY.divide(TWO, mc);
            }
            if (halfY.signum() > 0) {
                x = x.multiply(x, mc);
            }
            integerY = halfY;
        }
        return result.round(mathContext);
    }

    public static BigDecimal sqrt(BigDecimal x, MathContext mathContext) {
        BigDecimal last;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal sqrt(x) for x < 0: x = " + x);
            }
        }
        int maxPrecision = mathContext.getPrecision() + 6;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal result = BigDecimalMath.isDoubleValue(x) ? BigDecimal.valueOf(Math.sqrt(x.doubleValue())) : x.divide(TWO, mathContext);
        if (result.multiply(result, mathContext).compareTo(x) == 0) {
            return result.round(mathContext);
        }
        int adaptivePrecision = 17;
        do {
            last = result;
            if ((adaptivePrecision *= 2) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            result = x.divide(result, mc).add(last, mc).divide(TWO, mc);
        } while (adaptivePrecision < maxPrecision || result.subtract(last).abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n, MathContext mathContext) {
        BigDecimal step;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal root(x) for x < 0: x = " + x);
            }
        }
        if (n.compareTo(BigDecimal.ONE) <= 0) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            return BigDecimalMath.pow(x, BigDecimal.ONE.divide(n, mc), mathContext);
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal nMinus1 = n.subtract(BigDecimal.ONE);
        BigDecimal result = x.divide(TWO, MathContext.DECIMAL32);
        int adaptivePrecision = 2;
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            step = x.divide(BigDecimalMath.pow(result, nMinus1, mc), mc).subtract(result, mc).divide(n, mc);
            result = result.add(step, mc);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal log(BigDecimal x, MathContext mathContext) {
        BigDecimal result;
        if (x.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + x);
        }
        if (x.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (x.compareTo(BigDecimal.TEN)) {
            case 0: {
                result = BigDecimalMath.logTen(mathContext);
                break;
            }
            case 1: {
                result = BigDecimalMath.logUsingExponent(x, mathContext);
                break;
            }
            default: {
                result = BigDecimalMath.logUsingNewton(x, mathContext);
            }
        }
        return result.round(mathContext);
    }

    private static BigDecimal logUsingNewton(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        int adaptivePrecision;
        BigDecimal result;
        int maxPrecision = mathContext.getPrecision() + 20;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        if (BigDecimalMath.isDoubleValue(x)) {
            result = BigDecimal.valueOf(Math.log(x.doubleValue()));
            adaptivePrecision = 17;
        } else {
            result = x.divide(TWO, mathContext);
            adaptivePrecision = 1;
        }
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            BigDecimal expY = BigDecimalMath.exp(result, mc);
            step = TWO.multiply(x.subtract(expY, mc), mc).divide(x.add(expY, mc), mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result;
    }

    private static BigDecimal logUsingExponent(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() * 2, mathContext.getRoundingMode());
        int exponent = BigDecimalMath.exponent(x);
        BigDecimal mantissa = BigDecimalMath.mantissa(x);
        BigDecimal result = BigDecimalMath.logUsingNewton(mantissa, mc);
        if (exponent != 0) {
            result = result.add(BigDecimal.valueOf(exponent).multiply(BigDecimalMath.logTen(mc), mc), mc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTen(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log10CacheLock;
        synchronized (object) {
            if (log10Cache == null || mathContext.getPrecision() > log10Cache.precision()) {
                log10Cache = BigDecimalMath.logUsingNewton(BigDecimal.TEN, mathContext);
                return log10Cache;
            }
            result = log10Cache;
        }
        return result.round(mathContext);
    }

    public static BigDecimal exp(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimalMath.expIntegralFractional(x, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal x, MathContext mathContext) {
        BigDecimal integralPart = BigDecimalMath.integralPart(x);
        if (integralPart.signum() == 0) {
            return BigDecimalMath.expTaylor(x, mathContext);
        }
        BigDecimal fractionalPart = x.subtract(integralPart);
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal z = BigDecimal.ONE.add(fractionalPart.divide(integralPart, mc));
        BigDecimal t = BigDecimalMath.expTaylor(z, mc);
        BigDecimal result = BigDecimalMath.pow(t, integralPart.intValueExact(), mc);
        return result.round(mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimal.valueOf(256L), mc);
        BigDecimal result = ExpCalculator.INSTANCE.calculate(x, mc);
        result = BigDecimalMath.pow(result, 256L, mc);
        return result.round(mathContext);
    }

    static {
        BigDecimal result;
        TWO = BigDecimal.valueOf(2L);
        THREE = BigDecimal.valueOf(3L);
        MINUS_ONE = BigDecimal.valueOf(-1L);
        DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
        log2CacheLock = new Object();
        log3CacheLock = new Object();
        log10CacheLock = new Object();
        piCacheLock = new Object();
        eCacheLock = new Object();
        ROUGHLY_TWO_PI = new BigDecimal("3.141592653589793").multiply(TWO);
        factorialCache = new BigDecimal[100];
        BigDecimalMath.factorialCache[0] = result = BigDecimal.ONE;
        for (int i = 1; i < factorialCache.length; ++i) {
            BigDecimalMath.factorialCache[i] = result = result.multiply(BigDecimal.valueOf(i));
        }
    }
}

