/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.file;

import io.matthewnelson.kmp.file.AbstractFileStream;
import io.matthewnelson.kmp.file.FileStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0082\b\u001a\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0082\b\u00a8\u0006\t"}, d2={"asInputStream", "Ljava/io/InputStream;", "stream", "Lio/matthewnelson/kmp/file/FileStream$Read;", "closeParentOnClose", "", "asOutputStream", "Ljava/io/OutputStream;", "Lio/matthewnelson/kmp/file/FileStream$Write;", "io.matthewnelson.kmp-file_file_jvm"})
public final class FileStreamKt {
    private static final InputStream asInputStream(FileStream.Read stream, boolean closeParentOnClose) throws IOException {
        boolean $i$f$asInputStream = false;
        if (!stream.isOpen()) {
            throw new ClosedChannelException();
        }
        if (stream instanceof AbstractFileStream && !((AbstractFileStream)stream).getCanRead$io_matthewnelson_kmp_file_file_jvm()) {
            throw new IOException("AbstractFileStream.canRead != true");
        }
        return new InputStream(stream, closeParentOnClose){
            private volatile boolean _closed;
            final /* synthetic */ FileStream.Read $stream;
            final /* synthetic */ boolean $closeParentOnClose;
            {
                this.$stream = $stream;
                this.$closeParentOnClose = $closeParentOnClose;
            }

            public int available() {
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                long avail = this.$stream.size() - this.$stream.position();
                if (avail <= 0L) {
                    return 0;
                }
                if (avail > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)avail;
            }

            public int read() {
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                byte[] b = new byte[1];
                return this.$stream.read(b, 0, 1) == -1 ? -1 : b[0] & 0xFF;
            }

            public int read(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                return this.$stream.read(b, off, len);
            }

            public long skip(long n) {
                long l;
                try {
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    long posOld = this.$stream.position();
                    long posNew = posOld + n;
                    this.$stream.position(posNew);
                    l = posNew - posOld;
                }
                catch (IllegalArgumentException e) {
                    IOException iOException;
                    Throwable $this$wrapIOException$iv = e;
                    boolean $i$f$wrapIO = false;
                    Throwable throwable = $this$wrapIOException$iv;
                    if (throwable instanceof IOException) {
                        iOException = (IOException)$this$wrapIOException$iv;
                    } else if (throwable instanceof InterruptedException) {
                        InterruptedIOException interruptedIOException;
                        InterruptedIOException it$iv = interruptedIOException = new InterruptedIOException();
                        boolean bl = false;
                        ExceptionsKt.addSuppressed((Throwable)it$iv, (Throwable)$this$wrapIOException$iv);
                        iOException = interruptedIOException;
                    } else {
                        iOException = new IOException($this$wrapIOException$iv);
                    }
                    throw iOException;
                }
                return l;
            }

            public void close() {
                this._closed = true;
                if (this.$closeParentOnClose) {
                    this.$stream.close();
                }
            }
        };
    }

    private static final OutputStream asOutputStream(FileStream.Write stream, boolean closeParentOnClose) throws IOException {
        boolean $i$f$asOutputStream = false;
        if (!stream.isOpen()) {
            throw new ClosedChannelException();
        }
        if (stream instanceof AbstractFileStream && !((AbstractFileStream)stream).getCanWrite$io_matthewnelson_kmp_file_file_jvm()) {
            throw new IOException("AbstractFileStream.canWrite != true");
        }
        return new OutputStream(stream, closeParentOnClose){
            private volatile boolean _closed;
            final /* synthetic */ FileStream.Write $stream;
            final /* synthetic */ boolean $closeParentOnClose;
            {
                this.$stream = $stream;
                this.$closeParentOnClose = $closeParentOnClose;
            }

            public void write(int p0) {
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                byte[] byArray = new byte[]{(byte)p0};
                byte[] b = byArray;
                this.$stream.write(b);
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                this.$stream.write(b, off, len);
            }

            public void flush() {
                if (this._closed) {
                    throw new ClosedChannelException();
                }
                this.$stream.flush();
            }

            public void close() {
                this._closed = true;
                if (this.$closeParentOnClose) {
                    this.$stream.close();
                }
            }
        };
    }
}

