/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.file;

import io.matthewnelson.kmp.file.AbstractFileStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00102\u00060\u0001j\u0002`\u00022\u00020\u00032\u00020\u0004:\u0004\u0010\u0011\u0012\u0013J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bH&J\b\u0010\r\u001a\u00020\u000bH&J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tH&\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/kmp/file/FileStream;", "Ljava/io/Closeable;", "Lio/matthewnelson/kmp/file/Closeable;", "Ljava/io/Flushable;", "Ljava/nio/channels/InterruptibleChannel;", "close", "", "flush", "isOpen", "", "position", "", "new", "size", "sync", "meta", "Companion", "Read", "ReadWrite", "Write", "Lio/matthewnelson/kmp/file/FileStream$Read;", "Lio/matthewnelson/kmp/file/FileStream$Write;", "io.matthewnelson.kmp-file_file_jvm"})
public interface FileStream
extends Closeable,
Flushable,
InterruptibleChannel {
    @NotNull
    public static final Companion Companion = io.matthewnelson.kmp.file.FileStream$Companion.$$INSTANCE;

    @Override
    public boolean isOpen();

    @Override
    public void close() throws IOException;

    @Override
    public void flush() throws IOException;

    public long position() throws IOException;

    @NotNull
    public FileStream position(long var1) throws IOException;

    public long size() throws IOException;

    @NotNull
    public FileStream sync(boolean var1) throws IOException;

    @JvmStatic
    @NotNull
    public static InputStream asInputStream(@NotNull Read $this$asInputStream, boolean closeParentOnClose) throws ClosedChannelException {
        return Companion.asInputStream($this$asInputStream, closeParentOnClose);
    }

    @JvmStatic
    @NotNull
    public static OutputStream asOutputStream(@NotNull Write $this$asOutputStream, boolean closeParentOnClose) throws ClosedChannelException {
        return Companion.asOutputStream($this$asOutputStream, closeParentOnClose);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lio/matthewnelson/kmp/file/FileStream$Companion;", "", "()V", "asInputStream", "Ljava/io/InputStream;", "Lio/matthewnelson/kmp/file/FileStream$Read;", "closeParentOnClose", "", "asOutputStream", "Ljava/io/OutputStream;", "Lio/matthewnelson/kmp/file/FileStream$Write;", "io.matthewnelson.kmp-file_file_jvm"})
    @SourceDebugExtension(value={"SMAP\nFileStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStream.kt\nio/matthewnelson/kmp/file/FileStream$Companion\n+ 2 FileStream.kt\nio/matthewnelson/kmp/file/FileStreamKt\n*L\n1#1,314:1\n238#2,4:315\n284#2,4:319\n*S KotlinDebug\n*F\n+ 1 FileStream.kt\nio/matthewnelson/kmp/file/FileStream$Companion\n*L\n214#1:315,4\n231#1:319,4\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final InputStream asInputStream(@NotNull Read $this$asInputStream, boolean closeParentOnClose) throws ClosedChannelException {
            void stream$iv;
            Intrinsics.checkNotNullParameter((Object)$this$asInputStream, (String)"<this>");
            Read read = $this$asInputStream;
            boolean closeParentOnClose$iv = closeParentOnClose;
            boolean $i$f$asInputStream = false;
            if (!stream$iv.isOpen()) {
                throw new ClosedChannelException();
            }
            if (stream$iv instanceof AbstractFileStream && !((AbstractFileStream)stream$iv).getCanRead$io_matthewnelson_kmp_file_file_jvm()) {
                throw new IOException("AbstractFileStream.canRead != true");
            }
            return new InputStream((Read)stream$iv, closeParentOnClose$iv){
                private volatile boolean _closed;
                final /* synthetic */ Read $stream;
                final /* synthetic */ boolean $closeParentOnClose;
                {
                    this.$stream = $stream;
                    this.$closeParentOnClose = $closeParentOnClose;
                }

                public int available() {
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    long avail = this.$stream.size() - this.$stream.position();
                    if (avail <= 0L) {
                        return 0;
                    }
                    if (avail > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)avail;
                }

                public int read() {
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    byte[] b = new byte[1];
                    return this.$stream.read(b, 0, 1) == -1 ? -1 : b[0] & 0xFF;
                }

                public int read(byte[] b, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    return this.$stream.read(b, off, len);
                }

                public long skip(long n) {
                    long l;
                    try {
                        if (this._closed) {
                            throw new ClosedChannelException();
                        }
                        long posOld = this.$stream.position();
                        long posNew = posOld + n;
                        this.$stream.position(posNew);
                        l = posNew - posOld;
                    }
                    catch (IllegalArgumentException e) {
                        IOException iOException;
                        Throwable $this$wrapIOException$iv = e;
                        boolean $i$f$wrapIO = false;
                        Throwable throwable = $this$wrapIOException$iv;
                        if (throwable instanceof IOException) {
                            iOException = (IOException)$this$wrapIOException$iv;
                        } else if (throwable instanceof InterruptedException) {
                            InterruptedIOException interruptedIOException;
                            InterruptedIOException it$iv = interruptedIOException = new InterruptedIOException();
                            boolean bl = false;
                            ExceptionsKt.addSuppressed((Throwable)it$iv, (Throwable)$this$wrapIOException$iv);
                            iOException = interruptedIOException;
                        } else {
                            iOException = new IOException($this$wrapIOException$iv);
                        }
                        throw iOException;
                    }
                    return l;
                }

                public void close() {
                    this._closed = true;
                    if (this.$closeParentOnClose) {
                        this.$stream.close();
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final OutputStream asOutputStream(@NotNull Write $this$asOutputStream, boolean closeParentOnClose) throws ClosedChannelException {
            void stream$iv;
            Intrinsics.checkNotNullParameter((Object)$this$asOutputStream, (String)"<this>");
            Write write = $this$asOutputStream;
            boolean closeParentOnClose$iv = closeParentOnClose;
            boolean $i$f$asOutputStream = false;
            if (!stream$iv.isOpen()) {
                throw new ClosedChannelException();
            }
            if (stream$iv instanceof AbstractFileStream && !((AbstractFileStream)stream$iv).getCanWrite$io_matthewnelson_kmp_file_file_jvm()) {
                throw new IOException("AbstractFileStream.canWrite != true");
            }
            return new OutputStream((Write)stream$iv, closeParentOnClose$iv){
                private volatile boolean _closed;
                final /* synthetic */ Write $stream;
                final /* synthetic */ boolean $closeParentOnClose;
                {
                    this.$stream = $stream;
                    this.$closeParentOnClose = $closeParentOnClose;
                }

                public void write(int p0) {
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    byte[] byArray = new byte[]{(byte)p0};
                    byte[] b = byArray;
                    this.$stream.write(b);
                }

                public void write(byte[] b, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    this.$stream.write(b, off, len);
                }

                public void flush() {
                    if (this._closed) {
                        throw new ClosedChannelException();
                    }
                    this.$stream.flush();
                }

                public void close() {
                    this._closed = true;
                    if (this.$closeParentOnClose) {
                        this.$stream.close();
                    }
                }
            };
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void flush(@NotNull FileStream $this) throws IOException {
            $this.sync(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H&J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0005H&J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/kmp/file/FileStream$Read;", "Lio/matthewnelson/kmp/file/FileStream;", "Ljava/nio/channels/ReadableByteChannel;", "position", "new", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "buf", "", "offset", "len", "sync", "meta", "", "Lio/matthewnelson/kmp/file/FileStream$ReadWrite;", "Lio/matthewnelson/kmp/file/FileStreamReadOnly;", "io.matthewnelson.kmp-file_file_jvm"})
    public static interface Read
    extends FileStream,
    ReadableByteChannel {
        @Override
        @NotNull
        public Read position(long var1) throws IOException;

        public int read(@NotNull byte[] var1) throws IOException;

        public int read(@NotNull byte[] var1, int var2, int var3) throws IOException;

        public int read(@NotNull byte[] var1, long var2) throws IOException;

        public int read(@NotNull byte[] var1, int var2, int var3, long var4) throws IOException;

        @Override
        public int read(@Nullable ByteBuffer var1) throws IOException;

        public int read(@Nullable ByteBuffer var1, long var2) throws IOException;

        @Override
        @NotNull
        public Read sync(boolean var1) throws IOException;

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void flush(@NotNull Read $this) throws IOException {
                io.matthewnelson.kmp.file.FileStream$DefaultImpls.flush($this);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH&\u0082\u0001\u0001\f\u00a8\u0006\r"}, d2={"Lio/matthewnelson/kmp/file/FileStream$ReadWrite;", "Lio/matthewnelson/kmp/file/FileStream$Read;", "Lio/matthewnelson/kmp/file/FileStream$Write;", "Ljava/nio/channels/ByteChannel;", "()V", "position", "new", "", "size", "sync", "meta", "", "Lio/matthewnelson/kmp/file/AbstractFileStream;", "io.matthewnelson.kmp-file_file_jvm"})
    public static abstract class ReadWrite
    implements Read,
    Write,
    ByteChannel {
        private ReadWrite() {
        }

        @Override
        @NotNull
        public abstract ReadWrite position(long var1) throws IOException;

        @Override
        @NotNull
        public abstract ReadWrite size(long var1) throws IOException;

        @Override
        @NotNull
        public abstract ReadWrite sync(boolean var1) throws IOException;

        public /* synthetic */ ReadWrite(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004H&J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\bH&J\u0010\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J \u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH&J(\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\bH&J\u0018\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\bH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lio/matthewnelson/kmp/file/FileStream$Write;", "Lio/matthewnelson/kmp/file/FileStream;", "Ljava/nio/channels/WritableByteChannel;", "isAppending", "", "()Z", "position", "new", "", "size", "sync", "meta", "write", "", "src", "Ljava/nio/ByteBuffer;", "", "buf", "", "offset", "len", "Lio/matthewnelson/kmp/file/FileStream$ReadWrite;", "Lio/matthewnelson/kmp/file/FileStreamWriteOnly;", "io.matthewnelson.kmp-file_file_jvm"})
    public static interface Write
    extends FileStream,
    WritableByteChannel {
        public boolean isAppending();

        @Override
        @NotNull
        public Write position(long var1) throws IOException;

        @NotNull
        public Write size(long var1) throws IOException;

        @Override
        @NotNull
        public Write sync(boolean var1) throws IOException;

        public void write(@NotNull byte[] var1) throws IOException;

        public void write(@NotNull byte[] var1, int var2, int var3) throws IOException;

        public void write(@NotNull byte[] var1, long var2) throws IOException;

        public void write(@NotNull byte[] var1, int var2, int var3, long var4) throws IOException;

        @Override
        public int write(@Nullable ByteBuffer var1) throws IOException;

        public int write(@Nullable ByteBuffer var1, long var2) throws IOException;

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void flush(@NotNull Write $this) throws IOException {
                io.matthewnelson.kmp.file.FileStream$DefaultImpls.flush($this);
            }
        }
    }
}

