/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/gjt/jclasslib/structures/attributes/UnknownAttribute;", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "byteArrayLength", "", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(ILorg/gjt/jclasslib/structures/ClassFile;)V", "getByteArrayLength", "()I", "info", "", "getInfo", "()[B", "setInfo", "([B)V", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "getAttributeLength", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "getAttributeName", "data"})
public final class UnknownAttribute
extends AttributeInfo {
    private final int byteArrayLength;
    @NotNull
    private byte[] info;

    public UnknownAttribute(int byteArrayLength, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
        this.byteArrayLength = byteArrayLength;
        this.info = new byte[0];
    }

    public final int getByteArrayLength() {
        return this.byteArrayLength;
    }

    @NotNull
    public final byte[] getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.info = byArray;
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.info = input.readByteArray(this.byteArrayLength);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.write(this.info);
    }

    @Override
    public int getAttributeLength() {
        return this.info.length;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "of reported type " + this.getAttributeName();
    }

    private final String getAttributeName() {
        String string;
        try {
            string = this.getClassFile().getConstantPoolUtf8Entry(this.getAttributeNameIndex()).getString();
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            string = "(unknown)";
        }
        return string;
    }
}

