/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.Constant;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantFieldrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.gjt.jclasslib.structures.constants.ConstantPackageInfo;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ&\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lorg/gjt/jclasslib/structures/ConstantPoolUtil;", "", "<init>", "()V", "addConstantMethodrefInfo", "", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "className", "", "methodName", "methodSignature", "addConstantFieldrefInfo", "fieldName", "fieldType", "addConstantNameAndTypeInfo", "name", "descriptor", "addConstantClassInfo", "addConstantPackageInfo", "packageName", "addConstantUTF8Info", "string", "addConstantPoolEntry", "newEntry", "Lorg/gjt/jclasslib/structures/Constant;", "data"})
public final class ConstantPoolUtil {
    @NotNull
    public static final ConstantPoolUtil INSTANCE = new ConstantPoolUtil();

    private ConstantPoolUtil() {
    }

    public final int addConstantMethodrefInfo(@NotNull ClassFile classFile, @NotNull String className, @NotNull String methodName, @NotNull String methodSignature) {
        ConstantMethodrefInfo constantMethodrefInfo;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodSignature, (String)"methodSignature");
        int classIndex = this.addConstantClassInfo(classFile, className);
        int nameAndTypeIndex = this.addConstantNameAndTypeInfo(classFile, methodName, methodSignature);
        ConstantMethodrefInfo $this$addConstantMethodrefInfo_u24lambda_u240 = constantMethodrefInfo = new ConstantMethodrefInfo(classFile);
        boolean bl = false;
        $this$addConstantMethodrefInfo_u24lambda_u240.setClassIndex(classIndex);
        $this$addConstantMethodrefInfo_u24lambda_u240.setNameAndTypeIndex(nameAndTypeIndex);
        ConstantMethodrefInfo methodrefInfo = constantMethodrefInfo;
        return this.addConstantPoolEntry(classFile, methodrefInfo);
    }

    public final int addConstantFieldrefInfo(@NotNull ClassFile classFile, @NotNull String className, @NotNull String fieldName, @NotNull String fieldType) {
        ConstantFieldrefInfo constantFieldrefInfo;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        int classIndex = this.addConstantClassInfo(classFile, className);
        int nameAndTypeIndex = this.addConstantNameAndTypeInfo(classFile, fieldName, fieldType);
        ConstantFieldrefInfo $this$addConstantFieldrefInfo_u24lambda_u240 = constantFieldrefInfo = new ConstantFieldrefInfo(classFile);
        boolean bl = false;
        $this$addConstantFieldrefInfo_u24lambda_u240.setClassIndex(classIndex);
        $this$addConstantFieldrefInfo_u24lambda_u240.setNameAndTypeIndex(nameAndTypeIndex);
        ConstantFieldrefInfo fieldrefInfo = constantFieldrefInfo;
        return this.addConstantPoolEntry(classFile, fieldrefInfo);
    }

    public final int addConstantNameAndTypeInfo(@NotNull ClassFile classFile, @NotNull String name, @NotNull String descriptor) {
        ConstantNameAndTypeInfo constantNameAndTypeInfo;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int nameIndex = this.addConstantUTF8Info(classFile, name);
        int descriptorIndex = this.addConstantUTF8Info(classFile, descriptor);
        ConstantNameAndTypeInfo $this$addConstantNameAndTypeInfo_u24lambda_u240 = constantNameAndTypeInfo = new ConstantNameAndTypeInfo(classFile);
        boolean bl = false;
        $this$addConstantNameAndTypeInfo_u24lambda_u240.setNameIndex(nameIndex);
        $this$addConstantNameAndTypeInfo_u24lambda_u240.setDescriptorIndex(descriptorIndex);
        ConstantNameAndTypeInfo nameAndTypeInfo = constantNameAndTypeInfo;
        return this.addConstantPoolEntry(classFile, nameAndTypeInfo);
    }

    public final int addConstantClassInfo(@NotNull ClassFile classFile, @NotNull String className) {
        ConstantClassInfo constantClassInfo;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        int nameIndex = this.addConstantUTF8Info(classFile, className);
        ConstantClassInfo $this$addConstantClassInfo_u24lambda_u240 = constantClassInfo = new ConstantClassInfo(classFile);
        boolean bl = false;
        $this$addConstantClassInfo_u24lambda_u240.setNameIndex(nameIndex);
        ConstantClassInfo classInfo = constantClassInfo;
        return this.addConstantPoolEntry(classFile, classInfo);
    }

    public final int addConstantPackageInfo(@NotNull ClassFile classFile, @NotNull String packageName) {
        ConstantPackageInfo constantPackageInfo;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        int nameIndex = this.addConstantUTF8Info(classFile, packageName);
        ConstantPackageInfo $this$addConstantPackageInfo_u24lambda_u240 = constantPackageInfo = new ConstantPackageInfo(classFile);
        boolean bl = false;
        $this$addConstantPackageInfo_u24lambda_u240.setNameIndex(nameIndex);
        ConstantPackageInfo classInfo = constantPackageInfo;
        return this.addConstantPoolEntry(classFile, classInfo);
    }

    public final int addConstantUTF8Info(@NotNull ClassFile classFile, @NotNull String string) {
        ConstantUtf8Info constantUtf8Info;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ConstantUtf8Info $this$addConstantUTF8Info_u24lambda_u240 = constantUtf8Info = new ConstantUtf8Info(classFile);
        boolean bl = false;
        $this$addConstantUTF8Info_u24lambda_u240.setString(string);
        ConstantUtf8Info utf8Info = constantUtf8Info;
        return this.addConstantPoolEntry(classFile, utf8Info);
    }

    public final int addConstantPoolEntry(@NotNull ClassFile classFile, @NotNull Constant newEntry) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)newEntry, (String)"newEntry");
        Constant[] constantPool = classFile.getConstantPool();
        int index = classFile.getConstantPoolIndex(newEntry);
        if (index > -1) {
            return index;
        }
        int n = constantPool.length + 1;
        Constant[] constantArray = new Constant[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            constantArray[n2] = n2 == constantPool.length ? newEntry : constantPool[n2];
        }
        Constant[] newConstantPool = constantArray;
        classFile.enlargeConstantPool(newConstantPool);
        return constantPool.length;
    }
}

