/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.Instruction;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.io.CountingDataInput;
import org.gjt.jclasslib.io.CountingDataOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/gjt/jclasslib/bytecode/PaddedInstruction;", "Lorg/gjt/jclasslib/bytecode/Instruction;", "opcode", "Lorg/gjt/jclasslib/bytecode/Opcode;", "<init>", "(Lorg/gjt/jclasslib/bytecode/Opcode;)V", "getPaddedSize", "", "offset", "read", "", "input", "Lorg/gjt/jclasslib/io/CountingDataInput;", "write", "output", "Lorg/gjt/jclasslib/io/CountingDataOutput;", "paddingBytes", "bytesCount", "data"})
public abstract class PaddedInstruction
extends Instruction {
    public PaddedInstruction(@NotNull Opcode opcode) {
        Intrinsics.checkNotNullParameter((Object)opcode, (String)"opcode");
        super(opcode);
    }

    @Override
    public int getPaddedSize(int offset) {
        return this.getSize() + this.paddingBytes(offset + 1);
    }

    @Override
    public void read(@NotNull CountingDataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        int bytesToRead = this.paddingBytes(input.getBytesRead());
        int n = 0;
        while (n < bytesToRead) {
            int it = n++;
            boolean bl = false;
            input.readByte();
        }
    }

    @Override
    public void write(@NotNull CountingDataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        int bytesToWrite = this.paddingBytes(output.getBytesWritten());
        int n = 0;
        while (n < bytesToWrite) {
            int it = n++;
            boolean bl = false;
            output.writeByte(0);
        }
    }

    private final int paddingBytes(int bytesCount) {
        int bytesToPad = 4 - bytesCount % 4;
        return bytesToPad == 4 ? 0 : bytesToPad;
    }
}

