/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.probe.structures;

import com.jprofiler.agent.e.f.aa;
import com.jprofiler.agent.e.f.y;
import com.jprofiler.agent.probe.d.f;
import com.jprofiler.agent.probe.structures.TrackingInfo;
import com.jprofiler.agent.probe.structures.a;
import com.jprofiler.agent.probe.structures.c;
import com.jprofiler.agent.probe.structures.i;
import com.jprofiler.agent.probe.structures.j;
import com.jprofiler.agent.probe.structures.o;
import com.jprofiler.agent.probe.structures.s;
import com.jprofiler.agent.probe.structures.v;
import com.jprofiler.agent.util.t;
import com.jprofiler.api.agent.ProbeObjectType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProbeMetaData {
    public static final String MSG_NO_DESCRIPTION = "[No description set]";
    private String name;
    private String description = "[No description set]";
    private String payloadName;
    private boolean payload;
    private boolean recordEvents;
    private boolean telemetry;
    private boolean controlObjectView;
    private boolean deferredOperations;
    private boolean secondaryPayloads;
    private List<a> additionalControlObjectData = new ArrayList<a>();
    private List<s> telemetries = new ArrayList<s>();
    private List<c> additionalPayloadMetrics = new ArrayList<c>();
    private String[] sumNames = new String[0];
    private int telemetryCount;
    private int customTelemetryCount;
    private boolean annotatePayloads;
    private boolean formatPayloadOperation;
    private boolean uncappedEvents;
    private boolean untimed;
    private boolean partiallyTimed;
    private boolean heapWalkerControlObject;
    private boolean payloadHotspots = true;
    private boolean uncappedPayloads;
    private boolean async;
    private Integer eventCapOverride = null;
    private final Set<ProbeObjectType> trackableObjects = new HashSet<ProbeObjectType>();
    private transient y<s[]> customTypeToTelemetryDescriptors = new aa<s[]>();
    private transient y<Integer> customTypeToSumGroupIndex = new aa<Integer>();
    private j eventMetaData = new j();
    private List<j> specialEventMetaData = new ArrayList<j>();

    public static ProbeMetaData create(String string) {
        return new ProbeMetaData(string);
    }

    public ProbeMetaData() {
    }

    public ProbeMetaData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = string;
        this.payloadName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.description);
        dataOutputStream.writeUTF(this.payloadName);
        dataOutputStream.writeUTF(this.eventMetaData.e());
        dataOutputStream.writeUTF(this.eventMetaData.f());
        dataOutputStream.writeBoolean(this.payload);
        dataOutputStream.writeBoolean(this.recordEvents);
        dataOutputStream.writeBoolean(this.telemetry);
        dataOutputStream.writeBoolean(this.controlObjectView);
        dataOutputStream.writeBoolean(this.deferredOperations);
        dataOutputStream.writeBoolean(this.secondaryPayloads);
        Iterator<Object> iterator = this.trackableObjects;
        synchronized (iterator) {
            dataOutputStream.writeInt(this.trackableObjects.size());
            for (ProbeObjectType probeObjectType : this.trackableObjects) {
                dataOutputStream.writeInt(TrackingInfo.getObjectTypeIntValue(probeObjectType));
            }
        }
        dataOutputStream.writeInt(this.eventMetaData.g().a());
        this.eventMetaData.b(dataOutputStream);
        dataOutputStream.writeInt(this.additionalControlObjectData.size());
        for (a a2 : this.additionalControlObjectData) {
            a2.a(dataOutputStream);
        }
        dataOutputStream.writeInt(this.telemetries.size());
        for (s s2 : this.telemetries) {
            s2.a(dataOutputStream);
        }
        t.a((DataOutput)dataOutputStream, this.sumNames);
        t.a((DataOutput)dataOutputStream, this.eventMetaData.b());
        t.a((DataOutput)dataOutputStream, this.eventMetaData.d());
        t.a((DataOutput)dataOutputStream, this.eventMetaData.c());
        dataOutputStream.writeBoolean(this.formatPayloadOperation);
        dataOutputStream.writeBoolean(this.uncappedEvents);
        dataOutputStream.writeBoolean(this.untimed);
        dataOutputStream.writeBoolean(this.heapWalkerControlObject);
        dataOutputStream.writeBoolean(this.payloadHotspots);
        dataOutputStream.writeBoolean(this.uncappedPayloads);
        dataOutputStream.writeBoolean(this.async);
        dataOutputStream.writeBoolean(this.partiallyTimed);
        dataOutputStream.writeInt(this.specialEventMetaData.size());
        for (j j2 : this.specialEventMetaData) {
            j2.a(dataOutputStream);
        }
        dataOutputStream.writeInt(this.additionalPayloadMetrics.size());
        for (c c2 : this.additionalPayloadMetrics) {
            c2.a(dataOutputStream);
        }
    }

    public void read(DataInput dataInput, String string, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        this.name = dataInput.readUTF();
        this.description = com.jprofiler.agent.probe.o.a(dataInput.readUTF());
        this.payloadName = com.jprofiler.agent.probe.o.a(dataInput.readUTF());
        this.eventMetaData.a(com.jprofiler.agent.probe.o.a(dataInput.readUTF()));
        this.eventMetaData.b(com.jprofiler.agent.probe.o.a(dataInput.readUTF()));
        this.payload = dataInput.readBoolean();
        this.recordEvents = dataInput.readBoolean();
        this.telemetry = dataInput.readBoolean();
        this.controlObjectView = dataInput.readBoolean();
        if (n2 >= 32) {
            this.deferredOperations = dataInput.readBoolean();
            this.secondaryPayloads = dataInput.readBoolean();
            n5 = dataInput.readInt();
            for (n4 = 0; n4 < n5; ++n4) {
                this.trackableObjects.add(TrackingInfo.getObjectTypeFromIntValue(dataInput.readInt()));
            }
        }
        this.eventMetaData.a(f.a(dataInput.readInt()));
        this.eventMetaData.a(dataInput, n2);
        n5 = dataInput.readInt();
        for (n4 = 0; n4 < n5; ++n4) {
            this.additionalControlObjectData.add(a.a(dataInput, n2));
        }
        this.telemetryCount = s.a(this.telemetries, dataInput, n2);
        this.sumNames = t.a(dataInput);
        this.eventMetaData.a(t.a(dataInput));
        this.eventMetaData.b(t.a(dataInput));
        this.eventMetaData.a(t.a(dataInput, false));
        if (n2 >= 36) {
            this.formatPayloadOperation = dataInput.readBoolean();
        } else if ("builtin.PersistenceProbe".equals(string)) {
            this.formatPayloadOperation = true;
        }
        if (n2 >= 38) {
            this.uncappedEvents = dataInput.readBoolean();
            this.untimed = dataInput.readBoolean();
            this.heapWalkerControlObject = dataInput.readBoolean();
        }
        if (n2 >= 54) {
            this.payloadHotspots = dataInput.readBoolean();
            this.uncappedPayloads = dataInput.readBoolean();
        }
        if (n2 >= 59) {
            this.async = dataInput.readBoolean();
        }
        if (n2 >= 67) {
            this.partiallyTimed = dataInput.readBoolean();
        }
        if (n2 >= 47) {
            n4 = dataInput.readInt();
            for (n3 = 0; n3 < n4; ++n3) {
                this.specialEventMetaData.add(new j().b(dataInput, n2));
            }
        }
        if (n2 >= 69) {
            n4 = dataInput.readInt();
            for (n3 = 0; n3 < n4; ++n3) {
                this.additionalPayloadMetrics.add(c.a(dataInput, this.getNextMetricId(), n2));
            }
        }
    }

    public y<s[]> getCustomTypeToTelemetryDescriptors() {
        return this.customTypeToTelemetryDescriptors;
    }

    public y getCustomTypeToSumGroupIndex() {
        return this.customTypeToSumGroupIndex;
    }

    public ProbeMetaData addCountTelemetry(String string, int[] nArray, String string2, boolean bl2) {
        this.addBuiltInTelemetry(new s(3, this.telemetryCount++, string, v.b, 0, string2, bl2, false), nArray);
        return this;
    }

    public ProbeMetaData addThroughputTelemetry(String string, int[] nArray, String string2, boolean bl2, boolean bl3) {
        this.addBuiltInTelemetry(new s(4, this.telemetryCount++, string, v.d, 0, string2, bl2, bl3), nArray);
        return this;
    }

    public ProbeMetaData addAverageDurationTelemetry(String string, int[] nArray, String string2, boolean bl2) {
        this.addBuiltInTelemetry(new s(5, this.telemetryCount++, string, v.f, 0, string2, bl2, false), nArray);
        return this;
    }

    private void addBuiltInTelemetry(s s2, int[] nArray) {
        for (int n2 : nArray) {
            s[] sArray = (s[])this.customTypeToTelemetryDescriptors.get(n2);
            if (sArray == null) {
                sArray = new s[1];
            } else {
                s[] sArray2 = new s[sArray.length + 1];
                System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
                sArray = sArray2;
            }
            sArray[sArray.length - 1] = s2;
            this.customTypeToTelemetryDescriptors.put(n2, sArray);
        }
        this.telemetries.add(s2);
    }

    public ProbeMetaData addOpenControlObjectTelemetry(String string, String string2) {
        this.telemetries.add(new s(2, this.telemetryCount++, string, v.a, 0, string2, false, false));
        return this;
    }

    public ProbeMetaData addCustomTelemetry(String string, v v2, float f2, String string2, boolean bl2) {
        ++this.customTelemetryCount;
        this.telemetries.add(new s(1, this.telemetryCount++, string, v2, f2, string2, bl2));
        return this;
    }

    public ProbeMetaData addCustomTelemetry(String string, v v2, int n2, String string2, boolean bl2) {
        ++this.customTelemetryCount;
        this.telemetries.add(new s(1, this.telemetryCount++, string, v2, n2, string2, bl2, false));
        return this;
    }

    public ProbeMetaData addOpenControlObjectTelemetry(String string) {
        return this.addOpenControlObjectTelemetry(string, "");
    }

    private static int getScale(float f2) {
        return f2 == 0.0f ? 0 : (int)Math.round(Math.log10(f2));
    }

    public ProbeMetaData startTelemetryGroup(String string) {
        return this.startTelemetryGroup(string, false, false);
    }

    public ProbeMetaData startTelemetryGroup(String string, boolean bl2, boolean bl3) {
        return this.startTelemetryGroup(string, bl2, bl3, "", false);
    }

    public ProbeMetaData startTelemetryGroup(String string, boolean bl2, boolean bl3, String string2, boolean bl4) {
        this.telemetries.add(new s(string, bl2, string2, bl4, bl3));
        return this;
    }

    public int getCustomTelemetryCount() {
        return this.customTelemetryCount;
    }

    public ProbeMetaData addSumGroup(String string, int[] nArray) {
        Integer n2 = this.sumNames.length;
        String[] stringArray = new String[this.sumNames.length + 1];
        System.arraycopy(this.sumNames, 0, stringArray, 0, this.sumNames.length);
        stringArray[this.sumNames.length] = string;
        this.sumNames = stringArray;
        for (int n3 : nArray) {
            this.customTypeToSumGroupIndex.put(n3, n2);
        }
        return this;
    }

    public String[] getSumNames() {
        return this.sumNames;
    }

    public j getEventMetaData() {
        return this.eventMetaData;
    }

    public ProbeMetaData addAdditionalData(String string, i i2) {
        return this.addAdditionalData(string, i2, false, "");
    }

    public ProbeMetaData addAdditionalData(String string, i i2, boolean bl2) {
        this.eventMetaData.a(string, i2, bl2, "");
        return this;
    }

    public ProbeMetaData addAdditionalData(String string, i i2, boolean bl2, String string2) {
        this.eventMetaData.a(string, i2, bl2, string2);
        return this;
    }

    public ProbeMetaData addAdditionalControlObjectData(String string, i i2, boolean bl2) {
        this.additionalControlObjectData.add(new a(string, i2, bl2, false, this.description));
        return this;
    }

    public List<a> getAdditionalControlObjectData() {
        return this.additionalControlObjectData;
    }

    public ProbeMetaData addAdditionalPayloadMetric(String string, o o2, String string2, int ... nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + 10;
        }
        this.additionalPayloadMetrics.add(new c(string, o2, string2, this.getNextMetricId(), nArray));
        return this;
    }

    private int getNextMetricId() {
        return 10 + this.additionalPayloadMetrics.size();
    }

    public List<c> getAdditionalPayloadMetrics() {
        return this.additionalPayloadMetrics;
    }

    public List<s> getTelemetries() {
        return this.telemetries;
    }

    public ProbeMetaData customTypeNames(String ... stringArray) {
        this.eventMetaData.a(stringArray);
        return this;
    }

    public boolean isControlObjectView() {
        return this.controlObjectView;
    }

    public ProbeMetaData controlObjectView(boolean bl2) {
        this.controlObjectView = bl2;
        this.addTrackableObject(ProbeObjectType.CONTROL_OBJECT_FROM_DESCRIPTION);
        this.addTrackableObject(ProbeObjectType.CONTROL_OBJECT_FROM_ID);
        return this;
    }

    public ProbeMetaData customColors(int ... nArray) {
        this.eventMetaData.a(nArray);
        return this;
    }

    public boolean isPayload() {
        return this.payload;
    }

    public ProbeMetaData payload(boolean bl2) {
        this.payload = bl2;
        this.addTrackableObject(ProbeObjectType.HOTSPOT);
        return this;
    }

    public boolean isRecordEvents() {
        return this.recordEvents;
    }

    public ProbeMetaData events(boolean bl2) {
        this.recordEvents = bl2;
        return this;
    }

    public boolean isTelemetry() {
        return this.telemetry;
    }

    public ProbeMetaData telemetry(boolean bl2) {
        this.telemetry = bl2;
        return this;
    }

    public ProbeMetaData deferredOperations(boolean bl2) {
        this.deferredOperations = bl2;
        return this;
    }

    public boolean isDeferredOperations() {
        return this.deferredOperations;
    }

    public boolean isSecondaryPayloads() {
        return this.secondaryPayloads;
    }

    public ProbeMetaData secondaryPayloads(boolean bl2) {
        this.secondaryPayloads = bl2;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPayloadName() {
        return this.payloadName;
    }

    public ProbeMetaData payloadName(String string) {
        this.payloadName = string;
        return this;
    }

    public ProbeMetaData openTypeName(String string) {
        this.eventMetaData.a(string);
        return this;
    }

    public ProbeMetaData closeTypeName(String string) {
        this.eventMetaData.b(string);
        return this;
    }

    public ProbeMetaData description(String string) {
        this.description = string;
        return this;
    }

    public Collection getTrackableObjects() {
        return this.trackableObjects;
    }

    public ProbeMetaData addTrackableObject(ProbeObjectType probeObjectType) {
        this.trackableObjects.add(probeObjectType);
        return this;
    }

    public boolean isAnnotatePayloads() {
        return this.annotatePayloads;
    }

    public ProbeMetaData annotatePayloads(boolean bl2) {
        this.annotatePayloads = bl2;
        return this;
    }

    public int getTelemetryCount() {
        return this.telemetryCount;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProbeMetaData probeMetaData = (ProbeMetaData)object;
        if (this.uncappedEvents != probeMetaData.uncappedEvents) {
            return false;
        }
        if (this.untimed != probeMetaData.untimed) {
            return false;
        }
        if (this.payloadHotspots != probeMetaData.payloadHotspots) {
            return false;
        }
        if (this.uncappedPayloads != probeMetaData.uncappedPayloads) {
            return false;
        }
        if (this.payload != probeMetaData.payload) {
            return false;
        }
        if (this.telemetry != probeMetaData.telemetry) {
            return false;
        }
        if (this.deferredOperations != probeMetaData.deferredOperations) {
            return false;
        }
        if (this.secondaryPayloads != probeMetaData.secondaryPayloads) {
            return false;
        }
        if (this.recordEvents != probeMetaData.recordEvents) {
            return false;
        }
        if (this.additionalControlObjectData != null ? !this.additionalControlObjectData.equals(probeMetaData.additionalControlObjectData) : probeMetaData.additionalControlObjectData != null) {
            return false;
        }
        if (!Arrays.equals(this.sumNames, probeMetaData.sumNames)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(probeMetaData.name) : probeMetaData.name != null) {
            return false;
        }
        if (this.payloadName != null ? !this.payloadName.equals(probeMetaData.payloadName) : probeMetaData.payloadName != null) {
            return false;
        }
        if (this.telemetries != null ? !this.telemetries.equals(probeMetaData.telemetries) : probeMetaData.telemetries != null) {
            return false;
        }
        return this.eventMetaData.equals(probeMetaData.eventMetaData);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean isFormatPayloadOperation() {
        return this.formatPayloadOperation;
    }

    public ProbeMetaData formatPayloadOperation(boolean bl2) {
        this.formatPayloadOperation = bl2;
        return this;
    }

    public boolean isUncappedEvents() {
        return this.uncappedEvents;
    }

    public ProbeMetaData uncappedEvents(boolean bl2) {
        this.uncappedEvents = bl2;
        return this;
    }

    public boolean isUntimed() {
        return this.untimed;
    }

    public ProbeMetaData untimed(boolean bl2) {
        this.untimed = bl2;
        return this;
    }

    public boolean isPartiallyTimed() {
        return this.partiallyTimed;
    }

    public ProbeMetaData partiallyTimed(boolean bl2) {
        this.partiallyTimed = bl2;
        return this;
    }

    public boolean isPayloadHotspots() {
        return this.payload && this.payloadHotspots;
    }

    public ProbeMetaData payloadHotspots(boolean bl2) {
        this.payloadHotspots = bl2;
        return this;
    }

    public boolean isUncappedPayloads() {
        return this.uncappedPayloads;
    }

    public ProbeMetaData uncappedPayloads(boolean bl2) {
        this.uncappedPayloads = bl2;
        return this;
    }

    public Integer getEventCapOverride() {
        return this.eventCapOverride;
    }

    public ProbeMetaData eventCapOverride(int n2) {
        this.eventCapOverride = n2;
        return this;
    }

    public boolean isHeapWalkerControlObject() {
        return this.heapWalkerControlObject;
    }

    public ProbeMetaData heapWalkerControlObject(boolean bl2) {
        this.heapWalkerControlObject = bl2;
        return this;
    }

    public void addSpecialEventMetaData(j j2) {
        this.specialEventMetaData.add(j2);
    }

    public List<j> getSpecialEventMetaData() {
        return this.specialEventMetaData;
    }

    public ProbeMetaData async(boolean bl2) {
        this.async = bl2;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }
}

