/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlDisplayTextArea
extends JTextPane {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private Color overrideForeground;
    private Font overrideFont;

    public HtmlDisplayTextArea() {
        this.setEditable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.setRequestFocusEnabled(false);
        this.setMargin(NO_MARGIN);
        this.setEditorKit(new HTMLEditorKit());
        this.updateUI();
        this.setOpaque(false);
        this.setFocusable(false);
    }

    public void setOverrideForeground(Color overrideForeground) {
        this.overrideForeground = overrideForeground;
        this.updateUI();
    }

    public void setOverrideFont(Font overrideFont) {
        this.overrideFont = overrideFont;
        this.updateUI();
    }

    @Override
    public void setText(String text) {
        text = InstallerUtil.sanitizeHTML(text);
        super.setText(text);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet css = ((HTMLDocument)document).getStyleSheet();
            Font font = this.getUsedFont();
            css.addRule("body {color : #" + GUIHelper.getHexValue(this.getUsedForeground()) + " }");
            css.addRule("body {font-size : " + font.getSize() + "pt; }");
            css.addRule("body {font-family :" + font.getFontName() + "; }");
        }
    }

    private Font getUsedFont() {
        if (this.overrideFont != null) {
            return this.overrideFont;
        }
        return UIManager.getFont("Label.font");
    }

    private Color getUsedForeground() {
        if (this.overrideForeground != null) {
            return this.overrideForeground;
        }
        return UIManager.getColor("Label.foreground");
    }
}

