/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public class FileAssociations {
    private static final String FILE_EXTS_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts";
    private static final String USER_CHOICE_KEY = "UserChoice";
    private static final String PROGID = "Progid";
    private static final String ALTERNATIVE_HANDLER = "AlternativeHandler";
    private static final String CURRENT_USER_PREFIX = "SOFTWARE\\Classes\\";
    static final String SHELL_OPEN_COMMAND = "\\shell\\open\\command";

    public static List<SystemInstallOrUninstallAction> create(String extension, String description, File iconFile, File executable, String additionalParameters) throws UserCanceledException {
        boolean success;
        SystemInstallOrUninstallAction action;
        RegistryRoot classesRoot = Util.hasFullAdminRights() ? RegistryRoot.HKEY_CLASSES_ROOT : RegistryRoot.HKEY_CURRENT_USER;
        String keyPrefix = FileAssociations.getKeyPrefix(classesRoot);
        ArrayList<SystemInstallOrUninstallAction> ret = new ArrayList<SystemInstallOrUninstallAction>();
        ContextInt context = ContextImpl.getSingleContextInt();
        String internalNameBase = executable.getName().substring(0, executable.getName().length() - 4);
        if (additionalParameters == null) {
            additionalParameters = "";
        }
        if (!additionalParameters.isEmpty()) {
            additionalParameters = additionalParameters + " ";
        }
        String executableValue = "\"" + executable.getAbsolutePath() + "\" " + additionalParameters + "\"%1\"";
        int index = 0;
        String internalName = internalNameBase;
        while (WinRegistry.keyExists(classesRoot, keyPrefix + internalName)) {
            String commandKeyName = internalName + SHELL_OPEN_COMMAND;
            Object value = WinRegistry.getValue(classesRoot, keyPrefix + commandKeyName, "");
            if (value instanceof String && Objects.equals(value, executableValue) && FileAssociations.isEqualEntry(description, iconFile, classesRoot, keyPrefix + internalName)) break;
            internalName = internalNameBase + " " + ++index;
        }
        Logger.getInstance().info(null, "using internal name " + internalName);
        Object previousValue = WinRegistry.getValue(classesRoot, keyPrefix + extension, "");
        if (previousValue != null && !Objects.equals(previousValue.toString(), internalName) && WinRegistry.getValue(classesRoot, keyPrefix + extension, ALTERNATIVE_HANDLER) == null) {
            action = new SetRegistryValueAction(classesRoot, keyPrefix + extension, ALTERNATIVE_HANDLER, previousValue, true);
            success = ((SetRegistryValueAction)action).execute(context);
            Logger.getInstance().log(null, "setting alternative handler", success);
            ret.add(action);
        }
        if (!(success = (action = new SetRegistryValueAction(classesRoot, keyPrefix + extension, "", internalName, true)).execute(context))) {
            Logger.getInstance().error(null, "error setting internal name");
        }
        ret.add(action);
        action = new SetRegistryValueAction(classesRoot, keyPrefix + internalName, "", description, true);
        success = action.execute(context);
        if (!success) {
            Logger.getInstance().error(null, "error adding internal name");
        }
        ret.add(action);
        if (iconFile != null) {
            String iconKeyName = internalName + "\\DefaultIcon";
            action = new SetRegistryValueAction(classesRoot, keyPrefix + iconKeyName, "", iconFile.getAbsolutePath(), true);
            action.execute(context);
            ret.add(action);
        }
        String commandKeyName = internalName + SHELL_OPEN_COMMAND;
        action = new SetRegistryValueAction(classesRoot, keyPrefix + commandKeyName, "", executableValue, true);
        success = action.execute(context);
        if (!success) {
            Logger.getInstance().error(null, "error setting command key");
        }
        ret.add(action);
        if (WinRegistry.keyExists(RegistryRoot.HKEY_CURRENT_USER, FILE_EXTS_KEY)) {
            String keyName = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension;
            action = new SetRegistryValueAction(RegistryRoot.HKEY_CURRENT_USER, keyName, PROGID, internalName, true);
            action.execute(context);
            ret.add(action);
            keyName = keyName + "\\UserChoice";
            action = new DeleteRegistryItemAction(RegistryRoot.HKEY_CURRENT_USER, keyName, "", false);
            action.execute(context);
            ret.add(action);
        }
        Registry.changeNotifyAssociations();
        return ret;
    }

    private static boolean isEqualEntry(String description, File iconFile, RegistryRoot classesRoot, String keyName) {
        Object value = WinRegistry.getValue(classesRoot, keyName + "\\DefaultIcon", "");
        if (iconFile == null ? value instanceof String : !Objects.equals(iconFile.getAbsolutePath(), value)) {
            return false;
        }
        value = WinRegistry.getValue(classesRoot, keyName, "");
        return !(description == null ? value instanceof String : !Objects.equals(description, value));
    }

    public static boolean exists(String extension, RegistryRoot registryRoot) {
        if (registryRoot == RegistryRoot.HKEY_CLASSES_ROOT) {
            return WinRegistry.keyExists(RegistryRoot.HKEY_CLASSES_ROOT, extension);
        }
        return WinRegistry.keyExists(RegistryRoot.HKEY_CURRENT_USER, CURRENT_USER_PREFIX + extension);
    }

    public static String getExecutable(String extension, RegistryRoot registryRoot) {
        if (FileAssociations.exists(extension, registryRoot)) {
            return FileAssociations.getExecutableInt(extension, registryRoot, FileAssociations.getKeyPrefix(registryRoot));
        }
        return null;
    }

    static String getKeyPrefix(RegistryRoot registryRoot) {
        return registryRoot == RegistryRoot.HKEY_CURRENT_USER ? CURRENT_USER_PREFIX : "";
    }

    private static String getExecutableInt(String extension, RegistryRoot classesRoot, String keyPrefix) {
        Object internalName = WinRegistry.getValue(classesRoot, keyPrefix + extension, "");
        if (internalName != null) {
            StringTokenizer tok;
            Object command;
            String commandKeyName = internalName + SHELL_OPEN_COMMAND;
            if (WinRegistry.keyExists(classesRoot, keyPrefix + commandKeyName) && (command = WinRegistry.getValue(classesRoot, keyPrefix + commandKeyName, "")) != null && (tok = new StringTokenizer(command.toString(), "\"")).hasMoreTokens()) {
                return tok.nextToken();
            }
        }
        return null;
    }

    public static void remove(String extension, RegistryRoot classesRoot, boolean completely) throws UserCanceledException {
        try {
            String keyPrefix = FileAssociations.getKeyPrefix(classesRoot);
            String extensionKeyName = keyPrefix + extension;
            ContextInt context = ContextImpl.getSingleContextInt();
            String internalName = (String)WinRegistry.getValue(classesRoot, extensionKeyName, "");
            String previousInternalName = (String)WinRegistry.getValue(classesRoot, extensionKeyName, ALTERNATIVE_HANDLER);
            if (previousInternalName == null) {
                WinRegistry.deleteValue(classesRoot, extensionKeyName, "");
            } else {
                WinRegistry.setValue(classesRoot, extensionKeyName, "", previousInternalName);
            }
            if (completely && internalName != null && !internalName.trim().isEmpty()) {
                Object userAssoc;
                DeleteRegistryItemAction deleteAction = new DeleteRegistryItemAction(classesRoot, keyPrefix + internalName, "", false);
                deleteAction.execute(context);
                if (WinRegistry.getValue(classesRoot, extensionKeyName, ALTERNATIVE_HANDLER) != null) {
                    deleteAction = new DeleteRegistryItemAction(classesRoot, extensionKeyName, ALTERNATIVE_HANDLER, false);
                    deleteAction.execute(context);
                }
                if (previousInternalName == null) {
                    WinRegistry.deleteKey(classesRoot, extensionKeyName, true);
                }
                if ((userAssoc = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension, PROGID)) instanceof String && Objects.equals(userAssoc, internalName)) {
                    deleteAction = new DeleteRegistryItemAction(RegistryRoot.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension, PROGID, true);
                    deleteAction.execute(context);
                }
            }
            Registry.changeNotifyAssociations();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
    }
}

