/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MacFileSystem {
    private static final List<Pattern> PROTECTED_PATHS;

    private static List<Pattern> createMacosProtectedPaths(List<String> dirNames) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (String dirName : dirNames) {
            list.add(MacFileSystem.createUserDirProtectedPattern(dirName));
        }
        return Collections.unmodifiableList(list);
    }

    @NotNull
    private static Pattern createUserDirProtectedPattern(String dirName) {
        return Pattern.compile("^/Users/[^/]+/" + dirName + "(/|$)");
    }

    public static boolean isInProtectedDirectory(File file) {
        String absolutePath = file.getAbsolutePath();
        return PROTECTED_PATHS.stream().anyMatch(pattern -> pattern.matcher(absolutePath).find());
    }

    private static native void notifyChange0(String var0);

    private static native int setDefaultHandlerForURLScheme0(String var0, String var1);

    private static native int registerUrl0(String var0);

    public static boolean setExtendedAttribute(File destFile, String name, String value, boolean hex) {
        if (!Util.isMacOS()) {
            return false;
        }
        try {
            String[] command = hex ? new String[]{"xattr", "-w", "-s", "-x", name, value, destFile.getAbsolutePath()} : new String[]{"xattr", "-w", "-s", name, value, destFile.getAbsolutePath()};
            return Execution.executeAndWait(command, null);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void setDefaultHandlerForURLScheme(String scheme, String bundleId) {
        if (!Util.isMacOS()) {
            return;
        }
        MacFileSystem.setDefaultHandlerForURLScheme0(scheme, bundleId);
    }

    public static void notifyChange(File file) {
        if (!Util.isMacOS()) {
            return;
        }
        MacFileSystem.notifyChange0(file.getAbsolutePath());
    }

    public static void registerUrl(File file) {
        if (!Util.isMacOS()) {
            return;
        }
        MacFileSystem.registerUrl0(file.getAbsolutePath());
    }

    public static void notifyBundleChange(File appBundle) {
        MacFileSystem.notifyChange(appBundle);
        MacFileSystem.notifyChange(new File(appBundle, "Contents/Info.plist"));
        MacFileSystem.notifyChange(new File(appBundle, "Contents/Resources/app.icns"));
        MacFileSystem.registerUrl(appBundle);
    }

    static {
        Common.init();
        PROTECTED_PATHS = MacFileSystem.createMacosProtectedPaths(Arrays.asList("Desktop", "Documents", "Downloads", "Pictures", "Movies", "Music"));
    }
}

