/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.gui;

import java.awt.Color;

public class CommonColorUtil {
    public static String toHex(Color c) {
        return CommonColorUtil.toHex(c, false, true);
    }

    public static String toHex(Color c, boolean includeAlpha, boolean allowShort) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        if (includeAlpha) {
            if (allowShort && CommonColorUtil.shortable(r) && CommonColorUtil.shortable(g) && CommonColorUtil.shortable(b) && CommonColorUtil.shortable(a)) {
                return String.format("#%1x%1x%1x%1x", r >> 4, g >> 4, b >> 4, a >> 4);
            }
            return String.format("#%02x%02x%02x%02x", r, g, b, a);
        }
        if (allowShort && CommonColorUtil.shortable(r) && CommonColorUtil.shortable(g) && CommonColorUtil.shortable(b)) {
            return String.format("#%1x%1x%1x", r >> 4, g >> 4, b >> 4);
        }
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private static boolean shortable(int x) {
        return (x & 0xF0) == (x & 0xF) << 4;
    }
}

